package com.javapowertools.taxcalculator.services;

import static org.junit.Assert.*;

import java.util.Arrays;
import java.util.Collection;

import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.junit.runners.Parameterized.Parameters;

import com.javapowertools.taxcalculator.domain.TaxCalculator;

@RunWith(Parameterized.class)
public class TaxCalculatorTest {

    @Parameters
    public static Collection data() {
        return Arrays.asList(new Object[][]{
                /*  Dochd   Podatek */
                {     0.00,     0.00},
                { 10000.00,  1900.00},
                { 20000.00,  3800.00},
                { 43405.00,  8246.95},
                { 43406.00,  8247.25},
                { 50000.00, 10225,45},
                { 85528.00, 20883.85},
                {100000.00, 26672.65},
                {160000.00, 50672,65},
                {200000.00, 66672,65},
        });
    }

    private double revenue;
    private double expectedTax;
    private TaxCalculator calculator = new TaxCalculator();

    public TaxCalculatorTest(double input, double expectedTax) {
        this.revenue = input;
        this.expectedTax = expectedTax;
    }
    
    @Test public void calculateTax() {
        assertEquals(expectedTax, calculator.calculateIncomeTax(revenue), 0.0);
    }
}
