/*
 * Decompiled with CFR 0.152.
 */
package net.objectlab.qalab.parser;

import java.io.IOException;
import java.io.Writer;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import net.objectlab.qalab.parser.FileStats;
import net.objectlab.qalab.parser.SingleStat;
import net.objectlab.qalab.util.QALabTags;
import net.objectlab.qalab.util.TaskLogger;
import net.objectlab.qalab.util.Util;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class BuildStatMoverHandler
extends DefaultHandler {
    private static final int ONE_DAY = 24;
    private static final int WEEKEND_SKIP = 48;
    private List listOfTypes = new LinkedList();
    private TaskLogger tasklogger;
    private InputSource qalabSource;
    private Writer outputWriter;
    private Map mapOfTypes = new HashMap();
    private List filebeans = new LinkedList();
    private FileStats fileResult;
    private String filename;
    private String path;
    private Date startDateCutoff;
    private Date endDateCutoff;
    private Date startTimeWindow = null;
    private Date endTimeWindow = null;
    private String offsetHours;
    private boolean wkendadj = false;
    private boolean quiet = true;
    private int hoursOffsetForLastRun = 24;

    public BuildStatMoverHandler(InputSource qaLabSource, String types, Writer outputFile, boolean weekendAdjustment, TaskLogger log, boolean noDebug) {
        this.setLogger(log);
        this.quiet = noDebug;
        this.wkendadj = weekendAdjustment;
        this.listOfTypes = Util.listify(types, ",");
        this.processTypes(this.listOfTypes);
        this.outputWriter = outputFile;
        this.qalabSource = qaLabSource;
    }

    public final void process() throws ParserConfigurationException, SAXException, IOException {
        this.calculateCutoffDateTime();
        SAXParserFactory factory = SAXParserFactory.newInstance();
        SAXParser saxParser = factory.newSAXParser();
        saxParser.parse(this.getQalabSource(), (DefaultHandler)this);
    }

    private void processTypes(List listoftypes) {
        Iterator i = listoftypes.iterator();
        while (i.hasNext()) {
            this.mapOfTypes.put(i.next(), new Stack());
        }
    }

    public final void getFileName(Attributes attrs) {
        if (attrs != null) {
            for (int i = 0; i < attrs.getLength(); ++i) {
                String name = attrs.getQName(i);
                String value = attrs.getValue(i);
                if ("id".equals(name)) {
                    this.filename = value;
                    if (this.quiet) continue;
                    this.tasklogger.log("File:" + this.filename);
                    continue;
                }
                if (!"path".equals(name)) continue;
                this.path = value;
            }
        }
    }

    private SingleStat buildResultBean(Attributes attrs) {
        SingleStat singleStat = new SingleStat();
        if (attrs != null) {
            for (int i = 0; i < attrs.getLength(); ++i) {
                String name = attrs.getQName(i);
                String value = attrs.getValue(i);
                if ("type".equals(name)) {
                    singleStat.setType(value);
                    continue;
                }
                if ("statvalue".equals(name)) {
                    singleStat.setStatValue(Integer.parseInt(value));
                    continue;
                }
                if (!"date".equals(name)) continue;
                try {
                    if (value != null && value.length() > 10) {
                        singleStat.setDate(QALabTags.DEFAULT_DATETIME_FORMAT.parse(value));
                        continue;
                    }
                    if (value == null || value.length() != 10) continue;
                    singleStat.setDate(QALabTags.DEFAULT_DATE_FORMAT.parse(value));
                    continue;
                }
                catch (ParseException e) {
                    this.tasklogger.log(e.toString());
                }
            }
        }
        return singleStat;
    }

    public final void startElement(String ignoreNamespaceURI, String localname, String qualifiedname, Attributes attrs) throws SAXException {
        SingleStat resultbean;
        Stack s;
        String local = localname;
        if ("".equals(local)) {
            local = qualifiedname;
        }
        if ("file".equals(local)) {
            this.getFileName(attrs);
        }
        if ("result".equals(local) && (s = (Stack)this.mapOfTypes.get((resultbean = this.buildResultBean(attrs)).getType())) != null) {
            s.push(resultbean);
        }
    }

    public final void endElement(String ignoreNamespaceURI, String ignoreSimplename, String qualifiedname) throws SAXException {
        if ("file".equals(qualifiedname)) {
            this.fileResult = new FileStats(this.mapOfTypes, this.filename, this.path, this.startDateCutoff);
            this.fileResult.setEndDateCutoff(this.endDateCutoff);
            this.fileResult.setOffsetForLastRun(this.hoursOffsetForLastRun);
            this.filebeans.add(this.fileResult);
            this.mapOfTypes = new HashMap();
            this.processTypes(this.listOfTypes);
        }
    }

    public final InputSource getQalabSource() {
        return this.qalabSource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void endDocument() throws SAXException {
        try {
            FileStats fb;
            this.outputWriter.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
            this.outputWriter.write(QALabTags.LINE_END);
            this.outputWriter.write("<!DOCTYPE moversreport [");
            this.outputWriter.write(QALabTags.LINE_END);
            this.outputWriter.write("<!ELEMENT moversreport (types,datethreshold,enddatethreshold,daterun,up?,down?)>");
            this.outputWriter.write(QALabTags.LINE_END);
            this.outputWriter.write("<!ELEMENT types (#PCDATA)>");
            this.outputWriter.write(QALabTags.LINE_END);
            this.outputWriter.write("<!ELEMENT datethreshold (#PCDATA)>");
            this.outputWriter.write(QALabTags.LINE_END);
            this.outputWriter.write("<!ELEMENT enddatethreshold (#PCDATA)>");
            this.outputWriter.write(QALabTags.LINE_END);
            this.outputWriter.write("<!ELEMENT daterun (#PCDATA)>");
            this.outputWriter.write(QALabTags.LINE_END);
            this.outputWriter.write("<!ELEMENT up (file+)>");
            this.outputWriter.write(QALabTags.LINE_END);
            this.outputWriter.write("<!ELEMENT down (file+)>");
            this.outputWriter.write(QALabTags.LINE_END);
            this.outputWriter.write("<!ELEMENT file (diff+)>");
            this.outputWriter.write(QALabTags.LINE_END);
            this.outputWriter.write("<!ATTLIST file name CDATA #REQUIRED>");
            this.outputWriter.write(QALabTags.LINE_END);
            this.outputWriter.write("<!ATTLIST file path CDATA #REQUIRED>");
            this.outputWriter.write(QALabTags.LINE_END);
            this.outputWriter.write("<!ELEMENT diff EMPTY>");
            this.outputWriter.write(QALabTags.LINE_END);
            this.outputWriter.write("<!ATTLIST diff previousrun CDATA #REQUIRED>");
            this.outputWriter.write(QALabTags.LINE_END);
            this.outputWriter.write("<!ATTLIST diff currentrun CDATA #REQUIRED>");
            this.outputWriter.write(QALabTags.LINE_END);
            this.outputWriter.write("<!ATTLIST diff type CDATA #REQUIRED>");
            this.outputWriter.write(QALabTags.LINE_END);
            this.outputWriter.write("<!ATTLIST diff previouserrors CDATA #REQUIRED>");
            this.outputWriter.write(QALabTags.LINE_END);
            this.outputWriter.write("<!ATTLIST diff currenterrors CDATA #REQUIRED>");
            this.outputWriter.write(QALabTags.LINE_END);
            this.outputWriter.write("<!ATTLIST diff diff CDATA #REQUIRED>");
            this.outputWriter.write(QALabTags.LINE_END);
            this.outputWriter.write("]>");
            this.outputWriter.write(QALabTags.LINE_END);
            this.outputWriter.write("<moversreport>");
            this.outputWriter.write(QALabTags.LINE_END);
            this.outputWriter.write(" <types>");
            this.outputWriter.write(Util.listToCSVString(this.listOfTypes));
            this.outputWriter.write("</types>");
            this.outputWriter.write(QALabTags.LINE_END);
            this.outputWriter.write(" <datethreshold>");
            this.outputWriter.write(QALabTags.DEFAULT_DATETIME_FORMAT.format(this.startDateCutoff));
            this.outputWriter.write("</datethreshold>");
            this.outputWriter.write(QALabTags.LINE_END);
            this.outputWriter.write(" <enddatethreshold>");
            this.outputWriter.write(QALabTags.DEFAULT_DATETIME_FORMAT.format(this.endDateCutoff));
            this.outputWriter.write("</enddatethreshold>");
            this.outputWriter.write(QALabTags.LINE_END);
            this.outputWriter.write(" <daterun>");
            this.outputWriter.write(QALabTags.DEFAULT_DATETIME_FORMAT.format(new Date()));
            this.outputWriter.write("</daterun>");
            this.outputWriter.write(QALabTags.LINE_END);
            this.outputWriter.write(" <up>");
            this.outputWriter.write(QALabTags.LINE_END);
            Iterator it = this.filebeans.iterator();
            while (it.hasNext()) {
                fb = (FileStats)it.next();
                fb.constructXML();
                this.outputWriter.write(fb.getUpXmlResult());
            }
            this.outputWriter.write(" </up>");
            this.outputWriter.write(QALabTags.LINE_END);
            this.outputWriter.write(" <down>");
            this.outputWriter.write(QALabTags.LINE_END);
            it = this.filebeans.iterator();
            while (it.hasNext()) {
                fb = (FileStats)it.next();
                this.outputWriter.write(fb.getDownXmlResult());
            }
            this.outputWriter.write(" </down>");
            this.outputWriter.write(QALabTags.LINE_END);
            this.outputWriter.write("</moversreport>");
            this.outputWriter.flush();
        }
        catch (IOException e) {
            this.tasklogger.log(e.toString());
        }
        finally {
            if (this.outputWriter != null) {
                try {
                    this.outputWriter.close();
                }
                catch (IOException e) {
                    this.tasklogger.log(e.toString());
                }
            }
        }
    }

    public final void setDatecutoff(int offsetInHours) {
        Calendar cal = Calendar.getInstance();
        cal.add(10, offsetInHours);
        this.startDateCutoff = cal.getTime();
    }

    public final void calculateCutoffDateTime() {
        if (this.startTimeWindow != null) {
            this.startDateCutoff = this.startTimeWindow;
        } else {
            int offset = -Integer.parseInt(this.offsetHours);
            this.setDatecutoff(offset);
        }
        if (this.wkendadj) {
            Calendar cal = Calendar.getInstance();
            cal.setTime(this.startDateCutoff);
            int dayOfWeek = cal.get(7);
            if (dayOfWeek == 1 || dayOfWeek == 7) {
                cal.add(10, -48);
                this.startDateCutoff = cal.getTime();
            }
        }
        if (!this.quiet) {
            this.tasklogger.log("Cutoff = " + this.startDateCutoff);
        }
        this.endDateCutoff = this.endTimeWindow != null ? this.endTimeWindow : new Date();
    }

    private void setLogger(TaskLogger log) {
        this.tasklogger = log;
    }

    public final void setEndTimeWindow(Date endTime) {
        this.endTimeWindow = new Date(endTime.getTime());
    }

    public final void setStartTimeWindow(Date startTime) {
        this.startTimeWindow = new Date(startTime.getTime());
    }

    public final void setOffsetHours(String offset) {
        this.offsetHours = offset;
    }

    public final String getOffsetHours() {
        return this.offsetHours;
    }

    public int getHoursOffsetForLastRun() {
        return this.hoursOffsetForLastRun;
    }

    public void setHoursOffsetForLastRun(int hoursOffsetForLastRun) {
        this.hoursOffsetForLastRun = hoursOffsetForLastRun;
    }
}

