/*
 * Decompiled with CFR 0.152.
 */
package net.objectlab.qalab.ant;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import net.objectlab.qalab.ant.AntTaskLogger;
import net.objectlab.qalab.interfaces.QALabExporter;
import net.objectlab.qalab.parser.StatMerger;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.xml.sax.InputSource;

public class BuildStatMergeTask
extends Task {
    private File inputFile = null;
    private File outputFile = null;
    private boolean quiet = false;
    private String srcDir;
    private String handler;
    private String mergerTimeStamp;
    private String exporterClassName = "net.objectlab.qalab.exporter.QALabXMLExporter";
    private File propertiesFile;
    private Properties properties = null;

    public final void setHandler(String theHandler) {
        this.handler = theHandler;
    }

    private String getHandler() {
        return this.handler;
    }

    public final void setSrcDir(String sourceDirectory) {
        this.srcDir = sourceDirectory;
    }

    public final void setInputFile(File newStatisticsFile) {
        this.inputFile = newStatisticsFile;
    }

    public final void setOutputFile(File consolidatedFile) {
        this.outputFile = consolidatedFile;
    }

    public final void setQuiet(boolean noLog) {
        this.quiet = noLog;
    }

    public final void setMergerTimeStamp(String timestamp) {
        this.mergerTimeStamp = timestamp;
    }

    public final void execute() {
        this.properties = this.createOverridingProperties();
        this.validate();
        if (!this.quiet) {
            this.log("inputFile='" + this.inputFile.getPath() + "', outputFile='" + this.outputFile.getPath());
            this.log("srcDir='" + this.srcDir + "', mergerTimeStamp=" + this.mergerTimeStamp);
            this.log("quiet='" + this.quiet + "', propertiesFile=" + (this.propertiesFile != null ? this.propertiesFile.getPath() : null));
            Iterator<Map.Entry<Object, Object>> it = this.properties.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<Object, Object> entry = it.next();
                String key = entry.getKey().toString();
                if (key.indexOf("qalab") < 0) continue;
                this.log(key + " = '" + entry.getValue() + "'");
            }
        }
        this.mergeFiles();
    }

    private void mergeFiles() {
        try {
            AntTaskLogger logger = new AntTaskLogger(this);
            QALabExporter exporter = (QALabExporter)Class.forName(this.getExporterClassName()).newInstance();
            this.properties.setProperty("qalab.merge.output.file", this.outputFile.getAbsolutePath());
            exporter.setQuiet(this.quiet);
            exporter.setTaskLogger(logger);
            StatMerger merger = (StatMerger)Class.forName(this.getHandler()).newInstance();
            merger.setQuiet(this.quiet);
            merger.setSrcDir(this.srcDir);
            merger.setTaskLogger(logger);
            String tsOnly = this.properties.getProperty("qalab.merge.timestampdateonly");
            merger.setMergerTimeStamp(this.mergerTimeStamp, tsOnly != null && (tsOnly.equalsIgnoreCase("yes") || tsOnly.equalsIgnoreCase("true")));
            this.properties.setProperty("qalab.merge.output.timestamp", merger.getMergerTimeStamp());
            this.properties.setProperty("qalab.merge.type", merger.getType());
            exporter.configure(this.properties);
            merger.mergeStats(new InputSource(new FileReader(this.inputFile)), exporter);
            this.log("Files: " + merger.getFileCount() + " Statistics:" + merger.getTotalStatistics());
            exporter.save();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            throw new BuildException(e.toString());
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            throw new BuildException(e.toString());
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new BuildException(e.toString());
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            throw new BuildException(e.toString());
        }
        catch (InstantiationException e) {
            e.printStackTrace();
            throw new BuildException(e.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BuildException(e.toString());
        }
    }

    private void validate() {
        if (this.inputFile == null) {
            throw new BuildException("inputFile is mandatory");
        }
        if (!this.inputFile.canRead()) {
            String message = "Unable to read from " + this.inputFile + ".";
            throw new BuildException(message);
        }
    }

    public final void setExporterClassName(String exporterClass) {
        this.exporterClassName = exporterClass;
    }

    public final String getExporterClassName() {
        if (this.exporterClassName != null) {
            return this.exporterClassName;
        }
        return this.properties.getProperty("qalab.merge.exporterclass");
    }

    public final void setPropertiesFile(File aProps) {
        this.propertiesFile = aProps;
    }

    private Properties createOverridingProperties() {
        Properties retVal = new Properties();
        if (this.propertiesFile != null && this.propertiesFile.canRead() && this.propertiesFile.isFile()) {
            FileInputStream inStream = null;
            if (!this.quiet) {
                this.log("loading " + this.propertiesFile);
            }
            try {
                inStream = new FileInputStream(this.propertiesFile);
                retVal.load(inStream);
            }
            catch (FileNotFoundException e) {
                throw new BuildException("Could not find Properties file '" + this.propertiesFile + "'", (Throwable)e, this.getLocation());
            }
            catch (IOException e) {
                throw new BuildException("Error loading Properties file '" + this.propertiesFile + "'", (Throwable)e, this.getLocation());
            }
            finally {
                try {
                    if (inStream != null) {
                        inStream.close();
                    }
                }
                catch (IOException e) {
                    throw new BuildException("Error closing Properties file '" + this.propertiesFile + "'", (Throwable)e, this.getLocation());
                }
            }
        }
        Hashtable antProps = this.getProject().getProperties();
        Iterator it = antProps.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            String value = String.valueOf(entry.getValue());
            if (!this.quiet && entry.getKey().toString().indexOf("qalab") >= 0) {
                this.log("Adding Prop: " + entry.getKey() + " / [" + value + "]");
            }
            retVal.put(entry.getKey(), value);
        }
        return retVal;
    }
}

