/*
 * Decompiled with CFR 0.152.
 */
package demo;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JPanel;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.StandardXYItemRenderer;
import org.jfree.data.time.Day;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.ui.ApplicationFrame;
import org.jfree.ui.RectangleInsets;
import org.jfree.ui.RefineryUtilities;

public class MultipleDatasetDemo1
extends ApplicationFrame {
    public MultipleDatasetDemo1(String string) {
        super(string);
        this.setContentPane(MultipleDatasetDemo1.createDemoPanel());
    }

    public static JPanel createDemoPanel() {
        return new DemoPanel();
    }

    public static void main(String[] stringArray) {
        MultipleDatasetDemo1 multipleDatasetDemo1 = new MultipleDatasetDemo1("Multiple Dataset Demo 1");
        multipleDatasetDemo1.pack();
        RefineryUtilities.centerFrameOnScreen((Window)((Object)multipleDatasetDemo1));
        multipleDatasetDemo1.setVisible(true);
    }

    static class DemoPanel
    extends JPanel
    implements ActionListener {
        private XYPlot plot;
        private int datasetIndex = 0;

        public DemoPanel() {
            super(new BorderLayout());
            TimeSeriesCollection timeSeriesCollection = this.createRandomDataset("Series 1");
            JFreeChart jFreeChart = ChartFactory.createTimeSeriesChart("Multiple Dataset Demo 1", "Time", "Value", timeSeriesCollection, true, true, false);
            jFreeChart.setBackgroundPaint(Color.white);
            this.plot = (XYPlot)jFreeChart.getPlot();
            this.plot.setBackgroundPaint(Color.lightGray);
            this.plot.setDomainGridlinePaint(Color.white);
            this.plot.setRangeGridlinePaint(Color.white);
            this.plot.setAxisOffset(new RectangleInsets(4.0, 4.0, 4.0, 4.0));
            ValueAxis valueAxis = this.plot.getDomainAxis();
            valueAxis.setAutoRange(true);
            NumberAxis numberAxis = new NumberAxis("Range Axis 2");
            numberAxis.setAutoRangeIncludesZero(false);
            JPanel jPanel = new JPanel(new BorderLayout());
            ChartPanel chartPanel = new ChartPanel(jFreeChart);
            jPanel.add(chartPanel);
            JButton jButton = new JButton("Add Dataset");
            jButton.setActionCommand("ADD_DATASET");
            jButton.addActionListener(this);
            JButton jButton2 = new JButton("Remove Dataset");
            jButton2.setActionCommand("REMOVE_DATASET");
            jButton2.addActionListener(this);
            JPanel jPanel2 = new JPanel(new FlowLayout());
            jPanel2.add(jButton);
            jPanel2.add(jButton2);
            jPanel.add((Component)jPanel2, "South");
            chartPanel.setPreferredSize(new Dimension(500, 270));
            this.add(jPanel);
        }

        private TimeSeriesCollection createRandomDataset(String string) {
            TimeSeries timeSeries = new TimeSeries(string);
            double d = 100.0;
            RegularTimePeriod regularTimePeriod = new Day();
            for (int i = 0; i < 50; ++i) {
                timeSeries.add(regularTimePeriod, d);
                regularTimePeriod = ((RegularTimePeriod)regularTimePeriod).next();
                d *= 1.0 + Math.random() / 100.0;
            }
            return new TimeSeriesCollection(timeSeries);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getActionCommand().equals("ADD_DATASET")) {
                if (this.datasetIndex < 20) {
                    ++this.datasetIndex;
                    this.plot.setDataset(this.datasetIndex, this.createRandomDataset("S" + this.datasetIndex));
                    this.plot.setRenderer(this.datasetIndex, new StandardXYItemRenderer());
                }
            } else if (actionEvent.getActionCommand().equals("REMOVE_DATASET") && this.datasetIndex >= 1) {
                this.plot.setDataset(this.datasetIndex, null);
                this.plot.setRenderer(this.datasetIndex, null);
                --this.datasetIndex;
            }
        }
    }
}

