/*
 * Decompiled with CFR 0.152.
 */
package org.umlgraph.doclet;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.Tag;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.umlgraph.doclet.OptionProvider;
import org.umlgraph.doclet.RelationDirection;
import org.umlgraph.doclet.RelationPattern;
import org.umlgraph.doclet.RelationType;
import org.umlgraph.doclet.Shape;
import org.umlgraph.doclet.StringUtil;
import org.umlgraph.doclet.Visibility;

public class Options
implements Cloneable,
OptionProvider {
    private static String defaultFont;
    private static String defaultItalicFont;
    private static final Pattern allPattern;
    protected static final String DEFAULT_EXTERNAL_APIDOC = "http://java.sun.com/j2se/1.4.2/docs/api/";
    Vector<Pattern> hidePatterns;
    boolean showQualified = false;
    boolean showAttributes = false;
    boolean showEnumerations = false;
    boolean showEnumConstants = false;
    boolean showOperations = false;
    boolean showConstructors = false;
    boolean showVisibility = false;
    boolean horizontal;
    boolean showType = false;
    boolean showComment = false;
    String edgeFontName = defaultFont;
    String edgeFontColor = "black";
    String edgeColor = "black";
    double edgeFontSize = 10.0;
    String nodeFontName = defaultFont;
    String nodeFontAbstractName = defaultItalicFont;
    String nodeFontColor = "black";
    double nodeFontSize = 10.0;
    String nodeFillColor = null;
    double nodeFontClassSize = -1.0;
    String nodeFontClassName = null;
    String nodeFontClassAbstractName = null;
    double nodeFontTagSize = -1.0;
    String nodeFontTagName = null;
    double nodeFontPackageSize = -1.0;
    String nodeFontPackageName = null;
    Shape shape = new Shape();
    String bgColor = null;
    public String outputFileName = "graph.dot";
    String outputEncoding = "ISO-8859-1";
    Map<Pattern, String> apiDocMap;
    String apiDocRoot = null;
    boolean postfixPackage = false;
    boolean useGuillemot = true;
    boolean findViews = false;
    String viewName = null;
    public String outputDirectory = null;
    String guilOpen = "&laquo;";
    String guilClose = "&raquo;";
    boolean inferRelationships = false;
    boolean inferDependencies = false;
    RelationPattern contextRelationPattern;
    boolean useImports = false;
    Visibility inferDependencyVisibility;
    boolean inferDepInPackage = false;
    RelationType inferRelationshipType;
    private Vector<Pattern> collPackages;
    boolean compact = false;
    boolean relativeLinksForSourcePackages = false;
    boolean strictMatching;

    Options() {
        this.hidePatterns = new Vector();
        this.apiDocMap = new HashMap<Pattern, String>();
        this.contextRelationPattern = new RelationPattern(RelationDirection.BOTH);
        this.inferDependencyVisibility = Visibility.PRIVATE;
        this.inferRelationshipType = RelationType.NAVASSOC;
        this.collPackages = new Vector();
    }

    public Object clone() {
        Options clone = null;
        try {
            clone = (Options)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        clone.hidePatterns = new Vector<Pattern>(this.hidePatterns);
        clone.collPackages = new Vector<Pattern>(this.collPackages);
        clone.apiDocMap = new HashMap<Pattern, String>(this.apiDocMap);
        return clone;
    }

    public void setAll() {
        this.showAttributes = true;
        this.showEnumerations = true;
        this.showEnumConstants = true;
        this.showOperations = true;
        this.showConstructors = true;
        this.showVisibility = true;
        this.showType = true;
    }

    public static int optionLength(String option) {
        if (option.equals("-qualify") || option.equals("-horizontal") || option.equals("-attributes") || option.equals("-operations") || option.equals("-constructors") || option.equals("-visibility") || option.equals("-types") || option.equals("-commentname") || option.equals("-all") || option.equals("-postfixpackage") || option.equals("-noguillemot") || option.equals("-enumconstants") || option.equals("-enumerations") || option.equals("-views") || option.equals("-inferrel") || option.equals("-useimports") || option.equals("-inferdep") || option.equals("-inferdepinpackage") || option.equals("-compact")) {
            return 1;
        }
        if (option.equals("-nodefillcolor") || option.equals("-nodefontcolor") || option.equals("-nodefontsize") || option.equals("-nodefontname") || option.equals("-nodefontabstractname") || option.equals("-nodefontclasssize") || option.equals("-nodefontclassname") || option.equals("-nodefontclassabstractname") || option.equals("-nodefonttagsize") || option.equals("-nodefonttagname") || option.equals("-nodefontpackagesize") || option.equals("-nodefontpackagename") || option.equals("-edgefontcolor") || option.equals("-edgecolor") || option.equals("-edgefontsize") || option.equals("-edgefontname") || option.equals("-shape") || option.equals("-output") || option.equals("-outputencoding") || option.equals("-bgcolor") || option.equals("-hide") || option.equals("-apidocroot") || option.equals("-apidocmap") || option.equals("-d") || option.equals("-view") || option.equals("-inferreltype") || option.equals("-inferdepvis") || option.equals("-collpackages") || option.equals("-link")) {
            return 2;
        }
        if (option.equals("-contextPattern")) {
            return 3;
        }
        return 0;
    }

    void setOption(String[] opt) {
        if (!opt[0].equals("-hide") && Options.optionLength(opt[0]) > opt.length) {
            System.err.println("Skipping option '" + opt[0] + "', missing argument");
            return;
        }
        if (opt[0].equals("-qualify")) {
            this.showQualified = true;
        } else if (opt[0].equals("-!qualify")) {
            this.showQualified = false;
        } else if (opt[0].equals("-horizontal")) {
            this.horizontal = true;
        } else if (opt[0].equals("-!horizontal")) {
            this.horizontal = false;
        } else if (opt[0].equals("-attributes")) {
            this.showAttributes = true;
        } else if (opt[0].equals("-!attributes")) {
            this.showAttributes = false;
        } else if (opt[0].equals("-enumconstants")) {
            this.showEnumConstants = true;
        } else if (opt[0].equals("-!enumconstants")) {
            this.showEnumConstants = false;
        } else if (opt[0].equals("-operations")) {
            this.showOperations = true;
        } else if (opt[0].equals("-!operations")) {
            this.showOperations = false;
        } else if (opt[0].equals("-enumerations")) {
            this.showEnumerations = true;
        } else if (opt[0].equals("-!enumerations")) {
            this.showEnumerations = false;
        } else if (opt[0].equals("-constructors")) {
            this.showConstructors = true;
        } else if (opt[0].equals("-!constructors")) {
            this.showConstructors = false;
        } else if (opt[0].equals("-visibility")) {
            this.showVisibility = true;
        } else if (opt[0].equals("-!visibility")) {
            this.showVisibility = false;
        } else if (opt[0].equals("-types")) {
            this.showType = true;
        } else if (opt[0].equals("-!types")) {
            this.showType = false;
        } else if (opt[0].equals("-commentname")) {
            this.showComment = true;
        } else if (opt[0].equals("-!commentname")) {
            this.showComment = false;
        } else if (opt[0].equals("-all")) {
            this.setAll();
        } else if (opt[0].equals("-bgcolor")) {
            this.bgColor = opt[1];
        } else if (opt[0].equals("-!bgcolor")) {
            this.bgColor = null;
        } else if (opt[0].equals("-edgecolor")) {
            this.edgeColor = opt[1];
        } else if (opt[0].equals("-!edgecolor")) {
            this.edgeColor = "black";
        } else if (opt[0].equals("-edgefontcolor")) {
            this.edgeFontColor = opt[1];
        } else if (opt[0].equals("-!edgefontcolor")) {
            this.edgeFontColor = "black";
        } else if (opt[0].equals("-edgefontname")) {
            this.edgeFontName = opt[1];
        } else if (opt[0].equals("-!edgefontname")) {
            this.edgeFontName = defaultFont;
        } else if (opt[0].equals("-edgefontsize")) {
            this.edgeFontSize = Integer.parseInt(opt[1]);
        } else if (opt[0].equals("-!edgefontsize")) {
            this.edgeFontSize = 10.0;
        } else if (opt[0].equals("-nodefontcolor")) {
            this.nodeFontColor = opt[1];
        } else if (opt[0].equals("-!nodefontcolor")) {
            this.nodeFontColor = "black";
        } else if (opt[0].equals("-nodefontname")) {
            this.nodeFontName = opt[1];
        } else if (opt[0].equals("-!nodefontname")) {
            this.nodeFontName = defaultFont;
        } else if (opt[0].equals("-nodefontabstractname")) {
            this.nodeFontAbstractName = opt[1];
        } else if (opt[0].equals("-!nodefontabstractname")) {
            this.nodeFontAbstractName = defaultItalicFont;
        } else if (opt[0].equals("-nodefontsize")) {
            this.nodeFontSize = Integer.parseInt(opt[1]);
        } else if (opt[0].equals("-!nodefontsize")) {
            this.nodeFontSize = 10.0;
        } else if (opt[0].equals("-nodefontclassname")) {
            this.nodeFontClassName = opt[1];
        } else if (opt[0].equals("-!nodefontclassname")) {
            this.nodeFontClassName = null;
        } else if (opt[0].equals("-nodefontclassabstractname")) {
            this.nodeFontClassAbstractName = opt[1];
        } else if (opt[0].equals("-!nodefontclassabstractname")) {
            this.nodeFontClassAbstractName = null;
        } else if (opt[0].equals("-nodefontclasssize")) {
            this.nodeFontClassSize = Integer.parseInt(opt[1]);
        } else if (opt[0].equals("-!nodefontclasssize")) {
            this.nodeFontClassSize = -1.0;
        } else if (opt[0].equals("-nodefonttagname")) {
            this.nodeFontTagName = opt[1];
        } else if (opt[0].equals("-!nodefonttagname")) {
            this.nodeFontTagName = null;
        } else if (opt[0].equals("-nodefonttagsize")) {
            this.nodeFontTagSize = Integer.parseInt(opt[1]);
        } else if (opt[0].equals("-!nodefonttagsize")) {
            this.nodeFontTagSize = -1.0;
        } else if (opt[0].equals("-nodefontpackagename")) {
            this.nodeFontPackageName = opt[1];
        } else if (opt[0].equals("-!nodefontpackagename")) {
            this.nodeFontPackageName = null;
        } else if (opt[0].equals("-nodefontpackagesize")) {
            this.nodeFontPackageSize = Integer.parseInt(opt[1]);
        } else if (opt[0].equals("-!nodefontpackagesize")) {
            this.nodeFontPackageSize = -1.0;
        } else if (opt[0].equals("-nodefillcolor")) {
            this.nodeFillColor = opt[1];
        } else if (opt[0].equals("-!nodefillcolor")) {
            this.nodeFillColor = null;
        } else if (opt[0].equals("-shape")) {
            this.shape = new Shape(opt[1]);
        } else if (opt[0].equals("-!shape")) {
            this.shape = new Shape();
        } else if (opt[0].equals("-output")) {
            this.outputFileName = opt[1];
        } else if (opt[0].equals("-!output")) {
            this.outputFileName = "graph.dot";
        } else if (opt[0].equals("-outputencoding")) {
            this.outputEncoding = opt[1];
        } else if (opt[0].equals("-!outputencoding")) {
            this.outputEncoding = "ISO-8859-1";
        } else if (opt[0].equals("-hide")) {
            if (opt.length == 1) {
                this.hidePatterns.clear();
                this.hidePatterns.add(allPattern);
            } else {
                try {
                    this.hidePatterns.add(Pattern.compile(opt[1]));
                }
                catch (PatternSyntaxException e) {
                    System.err.println("Skipping invalid pattern " + opt[1]);
                }
            }
        } else if (opt[0].equals("-!hide")) {
            this.hidePatterns.clear();
        } else if (opt[0].equals("-apidocroot")) {
            this.apiDocRoot = this.fixApiDocRoot(opt[1]);
        } else if (opt[0].equals("-!apidocroot")) {
            this.apiDocRoot = null;
        } else if (opt[0].equals("-apidocmap")) {
            this.setApiDocMapFile(opt[1]);
        } else if (opt[0].equals("-!apidocmap")) {
            this.apiDocMap.clear();
        } else if (opt[0].equals("-noguillemot")) {
            this.guilOpen = "&lt;&lt;";
            this.guilClose = "&gt;&gt;";
        } else if (opt[0].equals("-!noguillemot")) {
            this.guilOpen = "\u00ab";
            this.guilClose = "\u00bb";
        } else if (opt[0].equals("-view")) {
            this.viewName = opt[1];
        } else if (opt[0].equals("-!view")) {
            this.viewName = null;
        } else if (opt[0].equals("-views")) {
            this.findViews = true;
        } else if (opt[0].equals("-!views")) {
            this.findViews = false;
        } else if (opt[0].equals("-d")) {
            this.outputDirectory = opt[1];
        } else if (opt[0].equals("-!d")) {
            this.outputDirectory = null;
        } else if (opt[0].equals("-inferrel")) {
            this.inferRelationships = true;
        } else if (opt[0].equals("-!inferrel")) {
            this.inferRelationships = false;
        } else if (opt[0].equals("-inferreltype")) {
            try {
                this.inferRelationshipType = RelationType.valueOf(opt[1].toUpperCase());
            }
            catch (IllegalArgumentException e) {
                System.err.println("Unknown association type " + opt[1]);
            }
        } else if (opt[0].equals("-!inferreltype")) {
            this.inferRelationshipType = RelationType.NAVASSOC;
        } else if (opt[0].equals("-inferdepvis")) {
            try {
                Visibility vis;
                this.inferDependencyVisibility = vis = Visibility.valueOf(opt[1].toUpperCase());
            }
            catch (IllegalArgumentException e) {
                System.err.println("Ignoring invalid visibility specification for dependency inference: " + opt[1]);
            }
        } else if (opt[0].equals("-!inferdepvis")) {
            this.inferDependencyVisibility = Visibility.PRIVATE;
        } else if (opt[0].equals("-inferdep")) {
            this.inferDependencies = true;
        } else if (opt[0].equals("-!inferdep")) {
            this.inferDependencies = false;
        } else if (opt[0].equals("-inferdepinpackage")) {
            this.inferDepInPackage = true;
        } else if (opt[0].equals("-!inferdepinpackage")) {
            this.inferDepInPackage = false;
        } else if (opt[0].equals("-useimports")) {
            this.useImports = true;
        } else if (opt[0].equals("-!useimports")) {
            this.useImports = false;
        } else if (opt[0].equals("-collpackages")) {
            try {
                this.collPackages.add(Pattern.compile(opt[1]));
            }
            catch (PatternSyntaxException e) {
                System.err.println("Skipping invalid pattern " + opt[1]);
            }
        } else if (opt[0].equals("-!collpackages")) {
            this.collPackages.clear();
        } else if (opt[0].equals("-compact")) {
            this.compact = true;
        } else if (opt[0].equals("-!compact")) {
            this.compact = false;
        } else if (opt[0].equals("-postfixpackage")) {
            this.postfixPackage = true;
        } else if (opt[0].equals("-!postfixpackage")) {
            this.postfixPackage = false;
        } else if (opt[0].equals("-link")) {
            this.addApiDocRoots(opt[1]);
        } else if (opt[0].equals("-contextPattern")) {
            try {
                RelationDirection d = RelationDirection.valueOf(opt[2].toUpperCase());
                if (opt[1].equalsIgnoreCase("all")) {
                    this.contextRelationPattern = new RelationPattern(d);
                } else {
                    RelationType rt = RelationType.valueOf(opt[1].toUpperCase());
                    this.contextRelationPattern.addRelation(rt, d);
                }
            }
            catch (IllegalArgumentException e) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addApiDocRoots(String packageListUrl) {
        BufferedReader br = null;
        packageListUrl = this.fixApiDocRoot(packageListUrl);
        try {
            URL url = new URL(packageListUrl + "/package-list");
            br = new BufferedReader(new InputStreamReader(url.openStream()));
            String line = null;
            while ((line = br.readLine()) != null) {
                line = line + ".";
                Pattern pattern = Pattern.compile(line.replace(".", "\\.") + "[^\\.]*");
                this.apiDocMap.put(pattern, packageListUrl);
            }
        }
        catch (IOException e) {
            System.err.println("Errors happened while accessing the package-list file at " + packageListUrl);
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    void setApiDocMapFile(String apiDocMapFileName) {
        try {
            FileInputStream is = new FileInputStream(apiDocMapFileName);
            Properties userMap = new Properties();
            userMap.load(is);
            for (Map.Entry<Object, Object> mapEntry : userMap.entrySet()) {
                try {
                    Pattern regex = Pattern.compile((String)mapEntry.getKey());
                    String thisRoot = (String)mapEntry.getValue();
                    if (thisRoot != null) {
                        thisRoot = this.fixApiDocRoot(thisRoot);
                        this.apiDocMap.put(regex, thisRoot);
                        continue;
                    }
                    System.err.println("No URL for pattern " + mapEntry.getKey());
                }
                catch (PatternSyntaxException e) {
                    System.err.println("Skipping bad pattern " + mapEntry.getKey());
                }
            }
        }
        catch (FileNotFoundException e) {
            System.err.println("File " + apiDocMapFileName + " was not found: " + e);
        }
        catch (IOException e) {
            System.err.println("Error reading the property api map file " + apiDocMapFileName + ": " + e);
        }
    }

    public String getApiDocRoot(String className) {
        if (this.apiDocMap.isEmpty()) {
            this.apiDocMap.put(Pattern.compile(".*"), DEFAULT_EXTERNAL_APIDOC);
        }
        for (Map.Entry<Pattern, String> mapEntry : this.apiDocMap.entrySet()) {
            Pattern regex = mapEntry.getKey();
            Matcher matcher = regex.matcher(className);
            if (!matcher.matches()) continue;
            return mapEntry.getValue();
        }
        return null;
    }

    private String fixApiDocRoot(String str) {
        String fixed = null;
        if (str != null && (fixed = str.trim()).length() > 0) {
            if (!File.separator.equals("/")) {
                fixed = fixed.replace(File.separator.charAt(0), '/');
            }
            if (!fixed.endsWith("/")) {
                fixed = fixed + "/";
            }
        }
        return fixed;
    }

    public void setOptions(String[][] options) {
        for (String[] s : options) {
            this.setOption(s);
        }
    }

    public void setOptions(ClassDoc p) {
        if (p == null) {
            return;
        }
        for (Tag tag : p.tags("opt")) {
            String[] opt = StringUtil.tokenize(tag.text());
            opt[0] = "-" + opt[0];
            this.setOption(opt);
        }
    }

    public boolean matchesHideExpression(String s) {
        for (Pattern hidePattern : this.hidePatterns) {
            if (hidePattern == allPattern) {
                return true;
            }
            Matcher m = hidePattern.matcher(s);
            if (!(this.strictMatching ? m.matches() : m.find())) continue;
            return true;
        }
        return false;
    }

    public boolean matchesCollPackageExpression(String s) {
        for (Pattern collPattern : this.collPackages) {
            Matcher m = collPattern.matcher(s);
            if (!(this.strictMatching ? m.matches() : m.find())) continue;
            return true;
        }
        return false;
    }

    @Override
    public Options getOptionsFor(ClassDoc cd) {
        Options localOpt = this.getGlobalOptions();
        localOpt.setOptions(cd);
        return localOpt;
    }

    @Override
    public Options getOptionsFor(String name) {
        return this.getGlobalOptions();
    }

    @Override
    public Options getGlobalOptions() {
        return (Options)this.clone();
    }

    @Override
    public void overrideForClass(Options opt, ClassDoc cd) {
    }

    @Override
    public void overrideForClass(Options opt, String className) {
    }

    @Override
    public String getDisplayName() {
        return "general class diagram";
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("UMLGRAPH OPTIONS\n");
        for (Field f : this.getClass().getDeclaredFields()) {
            if (Modifier.isStatic(f.getModifiers())) continue;
            f.setAccessible(true);
            try {
                sb.append(f.getName() + ":" + f.get(this) + "\n");
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return sb.toString();
    }

    static {
        allPattern = Pattern.compile(".*");
        if (System.getProperty("os.name").toLowerCase().contains("windows")) {
            defaultFont = "arial";
            defaultItalicFont = "ariali";
        } else {
            defaultFont = "Helvetica";
            defaultItalicFont = "Helvetica-Oblique";
        }
    }
}

