/*
 * Decompiled with CFR 0.152.
 */
package demo;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Paint;
import java.awt.Window;
import java.text.NumberFormat;
import javax.swing.JPanel;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.labels.ItemLabelAnchor;
import org.jfree.chart.labels.ItemLabelPosition;
import org.jfree.chart.labels.StandardCategoryItemLabelGenerator;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.DefaultDrawingSupplier;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.StackedBarRenderer;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;
import org.jfree.ui.ApplicationFrame;
import org.jfree.ui.RefineryUtilities;
import org.jfree.ui.TextAnchor;

public class ItemLabelDemo5
extends ApplicationFrame {
    public ItemLabelDemo5(String string) {
        super(string);
        JPanel jPanel = ItemLabelDemo5.createDemoPanel();
        jPanel.setPreferredSize(new Dimension(500, 270));
        this.setContentPane(jPanel);
    }

    public static CategoryDataset createDataset() {
        DefaultCategoryDataset defaultCategoryDataset = new DefaultCategoryDataset();
        defaultCategoryDataset.addValue(52.83, (Comparable)((Object)"Germany"), (Comparable)((Object)"Western EU"));
        defaultCategoryDataset.addValue(20.83, (Comparable)((Object)"France"), (Comparable)((Object)"Western EU"));
        defaultCategoryDataset.addValue(10.83, (Comparable)((Object)"Great Britain"), (Comparable)((Object)"Western EU"));
        defaultCategoryDataset.addValue(7.33, (Comparable)((Object)"Netherlands"), (Comparable)((Object)"Western EU"));
        defaultCategoryDataset.addValue(4.66, (Comparable)((Object)"Belgium"), (Comparable)((Object)"Western EU"));
        defaultCategoryDataset.addValue(57.14, (Comparable)((Object)"Spain"), (Comparable)((Object)"Southern EU"));
        defaultCategoryDataset.addValue(14.28, (Comparable)((Object)"Greece"), (Comparable)((Object)"Southern EU"));
        defaultCategoryDataset.addValue(14.28, (Comparable)((Object)"Italy"), (Comparable)((Object)"Southern EU"));
        defaultCategoryDataset.addValue(14.28, (Comparable)((Object)"Portugal"), (Comparable)((Object)"Southern EU"));
        defaultCategoryDataset.addValue(100.0, (Comparable)((Object)"Czech Republic"), (Comparable)((Object)"Eastern EU"));
        defaultCategoryDataset.addValue(66.66, (Comparable)((Object)"Denmark"), (Comparable)((Object)"Scandinavia"));
        defaultCategoryDataset.addValue(33.33, (Comparable)((Object)"Finland"), (Comparable)((Object)"Scandinavia"));
        defaultCategoryDataset.addValue(0.0, (Comparable)((Object)""), (Comparable)((Object)"Africa"));
        defaultCategoryDataset.addValue(100.0, (Comparable)((Object)"Israel"), (Comparable)((Object)"Asia"));
        return defaultCategoryDataset;
    }

    private static JFreeChart createChart(CategoryDataset categoryDataset) {
        JFreeChart jFreeChart = ChartFactory.createStackedBarChart("Item Label Demo 5", null, null, categoryDataset, PlotOrientation.VERTICAL, false, true, false);
        jFreeChart.setBackgroundPaint(new Color(255, 255, 255));
        CategoryPlot categoryPlot = (CategoryPlot)jFreeChart.getPlot();
        MyStackedBarRenderer myStackedBarRenderer = new MyStackedBarRenderer();
        categoryPlot.setRenderer(myStackedBarRenderer);
        ItemLabelPosition itemLabelPosition = new ItemLabelPosition(ItemLabelAnchor.CENTER, TextAnchor.CENTER, TextAnchor.CENTER, 0.0);
        myStackedBarRenderer.setPositiveItemLabelPositionFallback(itemLabelPosition);
        myStackedBarRenderer.setNegativeItemLabelPositionFallback(itemLabelPosition);
        StandardCategoryItemLabelGenerator standardCategoryItemLabelGenerator = new StandardCategoryItemLabelGenerator("{0}", NumberFormat.getInstance());
        myStackedBarRenderer.setItemLabelGenerator(standardCategoryItemLabelGenerator);
        myStackedBarRenderer.setItemLabelsVisible(true);
        NumberAxis numberAxis = (NumberAxis)categoryPlot.getRangeAxis();
        numberAxis.setUpperBound(100.0);
        return jFreeChart;
    }

    public static JPanel createDemoPanel() {
        JFreeChart jFreeChart = ItemLabelDemo5.createChart(ItemLabelDemo5.createDataset());
        return new ChartPanel(jFreeChart);
    }

    public static void main(String[] stringArray) {
        ItemLabelDemo5 itemLabelDemo5 = new ItemLabelDemo5("Item Label Demo 5");
        itemLabelDemo5.pack();
        RefineryUtilities.centerFrameOnScreen((Window)((Object)itemLabelDemo5));
        itemLabelDemo5.setVisible(true);
    }

    private static class MyStackedBarRenderer
    extends StackedBarRenderer {
        int oldColumn = -99;
        int count = 0;
        Paint[] list = DefaultDrawingSupplier.DEFAULT_PAINT_SEQUENCE;

        private MyStackedBarRenderer() {
        }

        public Paint getItemPaint(int n, int n2) {
            if (this.oldColumn != n2) {
                this.count = 0;
                this.oldColumn = n2;
            } else {
                ++this.count;
            }
            return this.list[this.count];
        }
    }
}

