/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.artifact.ant;

import hidden.org.codehaus.plexus.util.StringUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.ant.AbstractArtifactWithRepositoryTask;
import org.apache.maven.artifact.ant.AntDownloadMonitor;
import org.apache.maven.artifact.ant.AntResolutionListener;
import org.apache.maven.artifact.ant.Pom;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.manager.WagonManager;
import org.apache.maven.artifact.metadata.ArtifactMetadataSource;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolutionResult;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.artifact.resolver.filter.AndArtifactFilter;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.artifact.resolver.filter.ScopeArtifactFilter;
import org.apache.maven.artifact.resolver.filter.TypeArtifactFilter;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Repository;
import org.apache.maven.project.MavenProjectBuilder;
import org.apache.maven.project.artifact.InvalidDependencyVersionException;
import org.apache.maven.project.artifact.MavenMetadataSource;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.types.FileList;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Path;

public class DependenciesTask
extends AbstractArtifactWithRepositoryTask {
    private List dependencies = new ArrayList();
    private String pathId;
    private String filesetId;
    private String sourcesFilesetId;
    private String versionsId;
    private String useScope;
    private String type;
    private boolean verbose;
    static /* synthetic */ Class class$org$apache$maven$artifact$ant$DependenciesTask;

    protected void doExecute() {
        ArtifactResolutionResult result;
        this.showVersion();
        ArtifactRepository localRepo = this.createLocalArtifactRepository();
        this.log("Using local repository: " + localRepo.getBasedir(), 3);
        ArtifactResolver resolver = (ArtifactResolver)this.lookup(ArtifactResolver.ROLE);
        MavenProjectBuilder projectBuilder = (MavenProjectBuilder)this.lookup(MavenProjectBuilder.ROLE);
        ArtifactFactory artifactFactory = (ArtifactFactory)this.lookup(ArtifactFactory.ROLE);
        MavenMetadataSource metadataSource = (MavenMetadataSource)this.lookup(ArtifactMetadataSource.ROLE);
        List dependencies = this.dependencies;
        Pom pom = this.buildPom(projectBuilder, localRepo);
        if (pom != null) {
            if (!dependencies.isEmpty()) {
                throw new BuildException("You cannot specify both dependencies and a pom in the dependencies task");
            }
            dependencies = pom.getDependencies();
            Iterator i = pom.getRepositories().iterator();
            while (i.hasNext()) {
                Repository pomRepository = (Repository)i.next();
                this.addRemoteRepository(this.createAntRemoteRepository(pomRepository));
            }
        } else {
            pom = this.createDummyPom();
        }
        if (dependencies.isEmpty()) {
            this.log("There were no dependencies specified", 1);
        }
        this.log("Resolving dependencies...", 3);
        WagonManager wagonManager = (WagonManager)this.lookup(WagonManager.ROLE);
        wagonManager.setDownloadMonitor(new AntDownloadMonitor());
        List remoteArtifactRepositories = this.createRemoteArtifactRepositories();
        try {
            Set artifacts = MavenMetadataSource.createArtifacts(artifactFactory, dependencies, null, null, null);
            Artifact pomArtifact = artifactFactory.createBuildArtifact(pom.getGroupId(), pom.getArtifactId(), pom.getVersion(), pom.getPackaging());
            List<AntResolutionListener> listeners = Collections.singletonList(new AntResolutionListener(this.getProject(), this.verbose));
            Map managedDependencies = Collections.EMPTY_MAP;
            ArtifactFilter filter = null;
            if (this.useScope != null) {
                filter = new ScopeArtifactFilter(this.useScope);
            }
            if (this.type != null) {
                TypeArtifactFilter typeArtifactFilter = new TypeArtifactFilter(this.type);
                if (filter != null) {
                    AndArtifactFilter andFilter = new AndArtifactFilter();
                    andFilter.add(filter);
                    andFilter.add(typeArtifactFilter);
                    filter = andFilter;
                } else {
                    filter = typeArtifactFilter;
                }
            }
            result = resolver.resolveTransitively(artifacts, pomArtifact, managedDependencies, localRepo, remoteArtifactRepositories, metadataSource, filter, listeners);
        }
        catch (ArtifactResolutionException e) {
            throw new BuildException("Unable to resolve artifact: " + e.getMessage(), (Throwable)e);
        }
        catch (ArtifactNotFoundException e) {
            throw new BuildException("Dependency not found: " + e.getMessage(), (Throwable)e);
        }
        catch (InvalidDependencyVersionException e) {
            throw new BuildException(e.getMessage(), (Throwable)e);
        }
        FileList fileList = new FileList();
        fileList.setDir(this.getLocalRepository().getPath());
        FileSet fileSet = new FileSet();
        fileSet.setProject(this.getProject());
        fileSet.setDir(fileList.getDir(this.getProject()));
        FileList sourcesFileList = new FileList();
        sourcesFileList.setDir(this.getLocalRepository().getPath());
        FileSet sourcesFileSet = new FileSet();
        sourcesFileSet.setDir(sourcesFileList.getDir(this.getProject()));
        HashSet<String> versions = new HashSet<String>();
        if (result.getArtifacts().isEmpty()) {
            fileSet.createExclude().setName("**/**");
        } else {
            Iterator i = result.getArtifacts().iterator();
            while (i.hasNext()) {
                Artifact artifact = (Artifact)i.next();
                artifact.isSnapshot();
                String filename = localRepo.pathOf(artifact);
                FileList.FileName file = new FileList.FileName();
                file.setName(filename);
                fileList.addConfiguredFile(file);
                fileSet.createInclude().setName(filename);
                versions.add(artifact.getBaseVersion());
                if (this.sourcesFilesetId == null) continue;
                this.log("Resolving dependencies sources...", 3);
                Artifact sourcesArtifact = artifactFactory.createArtifactWithClassifier(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion(), "java-source", "sources");
                if (sourcesArtifact == null) continue;
                try {
                    resolver.resolve(sourcesArtifact, remoteArtifactRepositories, localRepo);
                    String sourcesFilename = localRepo.pathOf(sourcesArtifact);
                    FileList.FileName sourcesFile = new FileList.FileName();
                    sourcesFile.setName(sourcesFilename);
                    sourcesFileList.addConfiguredFile(sourcesFile);
                    sourcesFileSet.createInclude().setName(sourcesFilename);
                }
                catch (ArtifactResolutionException e) {
                    throw new BuildException("Unable to resolve artifact: " + e.getMessage(), (Throwable)e);
                }
                catch (ArtifactNotFoundException e) {
                }
            }
        }
        if (this.pathId != null) {
            Path path = new Path(this.getProject());
            path.addFilelist(fileList);
            this.getProject().addReference(this.pathId, (Object)path);
        }
        if (this.filesetId != null) {
            this.getProject().addReference(this.filesetId, (Object)fileSet);
        }
        if (this.sourcesFilesetId != null) {
            this.getProject().addReference(this.sourcesFilesetId, (Object)sourcesFileSet);
        }
        if (this.versionsId != null) {
            String versionsValue = StringUtils.join(versions.iterator(), File.pathSeparator);
            this.getProject().setNewProperty(this.versionsId, versionsValue);
        }
    }

    public List getDependencies() {
        return this.dependencies;
    }

    public void addDependency(Dependency dependency) {
        this.dependencies.add(dependency);
    }

    public String getPathId() {
        return this.pathId;
    }

    public void setPathId(String pathId) {
        this.pathId = pathId;
    }

    public String getFilesetId() {
        return this.filesetId;
    }

    public void setSourcesFilesetId(String filesetId) {
        this.sourcesFilesetId = filesetId;
    }

    public String getSourcesFilesetId() {
        return this.sourcesFilesetId;
    }

    public void setFilesetId(String filesetId) {
        this.filesetId = filesetId;
    }

    public String getVersionsId() {
        return this.versionsId;
    }

    public void setVersionsId(String versionsId) {
        this.versionsId = versionsId;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public void setUseScope(String useScope) {
        this.useScope = useScope;
    }

    public void setType(String type) {
        this.type = type;
    }

    private void showVersion() {
        try {
            Properties properties = new Properties();
            InputStream resourceAsStream = (class$org$apache$maven$artifact$ant$DependenciesTask == null ? (class$org$apache$maven$artifact$ant$DependenciesTask = DependenciesTask.class$("org.apache.maven.artifact.ant.DependenciesTask")) : class$org$apache$maven$artifact$ant$DependenciesTask).getClassLoader().getResourceAsStream("META-INF/maven/org.apache.maven/maven-ant-tasks/pom.properties");
            properties.load(resourceAsStream);
            if (properties.getProperty("builtOn") != null) {
                this.log("Maven Ant Tasks version: " + properties.getProperty("version", "unknown") + " built on " + properties.getProperty("builtOn"), 3);
            } else {
                this.log("Maven Ant Tasks version: " + properties.getProperty("version", "unknown"), 3);
            }
        }
        catch (IOException e) {
            this.log("Unable determine version from Maven Ant Tasks JAR file: " + e.getMessage(), 1);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

