/*
 * Decompiled with CFR 0.152.
 */
package hidden.org.codehaus.plexus.util;

import java.util.Locale;

public class Os {
    private static final String OS_NAME = System.getProperty("os.name").toLowerCase(Locale.US);
    private static final String OS_ARCH = System.getProperty("os.arch").toLowerCase(Locale.US);
    private static final String OS_VERSION = System.getProperty("os.version").toLowerCase(Locale.US);
    private static final String PATH_SEP = System.getProperty("path.separator");
    private String family;
    private String name;
    private String version;
    private String arch;

    public Os() {
    }

    public Os(String family) {
        this.setFamily(family);
    }

    public void setFamily(String f) {
        this.family = f.toLowerCase(Locale.US);
    }

    public void setName(String name) {
        this.name = name.toLowerCase(Locale.US);
    }

    public void setArch(String arch) {
        this.arch = arch.toLowerCase(Locale.US);
    }

    public void setVersion(String version) {
        this.version = version.toLowerCase(Locale.US);
    }

    public boolean eval() throws Exception {
        return Os.isOs(this.family, this.name, this.arch, this.version);
    }

    public static boolean isFamily(String family) {
        return Os.isOs(family, null, null, null);
    }

    public static boolean isName(String name) {
        return Os.isOs(null, name, null, null);
    }

    public static boolean isArch(String arch) {
        return Os.isOs(null, null, arch, null);
    }

    public static boolean isVersion(String version) {
        return Os.isOs(null, null, null, version);
    }

    public static boolean isOs(String family, String name, String arch, String version) {
        boolean retValue = false;
        if (family != null || name != null || arch != null || version != null) {
            boolean isFamily = true;
            boolean isName = true;
            boolean isArch = true;
            boolean isVersion = true;
            if (family != null) {
                isFamily = family.equalsIgnoreCase("windows") ? OS_NAME.indexOf("windows") > -1 : (family.equalsIgnoreCase("os/2") ? OS_NAME.indexOf("os/2") > -1 : (family.equalsIgnoreCase("netware") ? OS_NAME.indexOf("netware") > -1 : (family.equalsIgnoreCase("dos") ? PATH_SEP.equals(";") && !Os.isFamily("netware") : (family.equalsIgnoreCase("mac") ? OS_NAME.indexOf("mac") > -1 : (family.equalsIgnoreCase("tandem") ? OS_NAME.indexOf("nonstop_kernel") > -1 : (family.equalsIgnoreCase("unix") ? PATH_SEP.equals(":") && !Os.isFamily("openvms") && (!Os.isFamily("mac") || OS_NAME.endsWith("x")) : (family.equalsIgnoreCase("win9x") ? Os.isFamily("windows") && (OS_NAME.indexOf("95") >= 0 || OS_NAME.indexOf("98") >= 0 || OS_NAME.indexOf("me") >= 0 || OS_NAME.indexOf("ce") >= 0) : (family.equalsIgnoreCase("z/os") ? OS_NAME.indexOf("z/os") > -1 || OS_NAME.indexOf("os/390") > -1 : (family.equalsIgnoreCase("os/400") ? OS_NAME.indexOf("os/400") > -1 : (family.equalsIgnoreCase("openvms") ? OS_NAME.indexOf("openvms") > -1 : false))))))))));
            }
            if (name != null) {
                isName = name.toLowerCase(Locale.US).equals(OS_NAME);
            }
            if (arch != null) {
                isArch = arch.toLowerCase(Locale.US).equals(OS_ARCH);
            }
            if (version != null) {
                isVersion = version.toLowerCase(Locale.US).equals(OS_VERSION);
            }
            retValue = isFamily && isName && isArch && isVersion;
        }
        return retValue;
    }
}

