/*
 * Decompiled with CFR 0.152.
 */
package net.objectlab.qalab.m2;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.text.ParseException;
import javax.xml.parsers.ParserConfigurationException;
import net.objectlab.qalab.m2.util.Maven2TaskLogger;
import net.objectlab.qalab.m2.util.Utils;
import net.objectlab.qalab.parser.BuildStatMoverHandler;
import net.objectlab.qalab.util.QALabTags;
import net.objectlab.qalab.util.TaskLogger;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.Mojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class BuildStatMoversMojo
extends AbstractMojo {
    private static final int MIN_DATE_SIZE = 18;
    private File qalabFile = null;
    private String startTimeHoursOffset = null;
    private String types = "checkstyle,pmd,findbugs,cobertura-line,cobertura-branch";
    private File qalabMoversOutputFile;
    private boolean quiet = false;
    private boolean weekendAdjustment = true;
    private String startTimeWindow = null;
    private String endTimeWindow = null;

    public final void execute() throws MojoExecutionException {
        this.validate();
        if (!this.quiet) {
            this.getLog().info((CharSequence)("QALAB Movers ==> qalabFile='" + this.qalabFile.getPath()));
            this.getLog().info((CharSequence)("type=" + this.types));
            this.getLog().info((CharSequence)("output=" + this.qalabMoversOutputFile.getPath()));
            this.getLog().info((CharSequence)("adjustForWeekend=" + this.weekendAdjustment));
            this.getLog().info((CharSequence)("startTimeOffset=" + this.startTimeHoursOffset));
            this.getLog().info((CharSequence)("startTimeWindow=" + this.startTimeWindow));
            this.getLog().info((CharSequence)("endTimeWindow=" + this.endTimeWindow));
        }
        try {
            Maven2TaskLogger logger = new Maven2TaskLogger((Mojo)this);
            BuildStatMoverHandler handler = new BuildStatMoverHandler(new InputSource(new FileReader(this.qalabFile)), this.types, (Writer)new FileWriter(this.qalabMoversOutputFile), this.weekendAdjustment, (TaskLogger)logger, this.quiet);
            if (this.startTimeWindow != null) {
                handler.setStartTimeWindow(QALabTags.DEFAULT_DATETIME_FORMAT.parse(this.fixTime(this.startTimeWindow)));
            }
            if (this.endTimeWindow != null) {
                handler.setEndTimeWindow(QALabTags.DEFAULT_DATETIME_FORMAT.parse(this.fixTime(this.endTimeWindow)));
            }
            if (this.startTimeHoursOffset != null) {
                handler.setOffsetHours(this.startTimeHoursOffset);
            }
            handler.process();
        }
        catch (ParserConfigurationException pcex) {
            this.getLog().error((CharSequence)pcex.toString());
        }
        catch (SAXException sex) {
            this.getLog().error((CharSequence)sex.toString());
        }
        catch (IOException ioex) {
            this.getLog().error((CharSequence)ioex.toString());
        }
        catch (ParseException pex) {
            throw new MojoExecutionException("Date Parse issue", (Exception)pex);
        }
    }

    private void validate() throws MojoExecutionException {
        try {
            Utils.checkFile(this.qalabFile, "qalabFile");
        }
        catch (IOException ioex) {
            throw new MojoExecutionException(ioex.getMessage(), (Exception)ioex);
        }
        if (this.startTimeHoursOffset == null && this.startTimeWindow == null) {
            throw new MojoExecutionException("Please set startTimeHoursOffset or startTimeWindow.");
        }
        if (this.startTimeHoursOffset != null && this.startTimeWindow != null) {
            throw new MojoExecutionException("Use startTimeHoursOffset OR startTimeWindow, not both.");
        }
        File dir = this.qalabMoversOutputFile.getParentFile();
        if (!dir.exists()) {
            dir.mkdirs();
        }
    }

    private String fixTime(String aTime) {
        String result = aTime.trim();
        if (result.length() < 18) {
            result = result + " 00:00:00";
        }
        return result;
    }

    public String getEndTimeWindow() {
        return this.endTimeWindow;
    }

    public void setEndTimeWindow(String endTimeWindow) {
        this.endTimeWindow = endTimeWindow;
    }

    public File getQalabFile() {
        return this.qalabFile;
    }

    public void setQalabFile(File qalabFile) {
        this.qalabFile = qalabFile;
    }

    public File getQalabMoversOutputFile() {
        return this.qalabMoversOutputFile;
    }

    public void setQalabMoversOutputFile(File qalabMoversOutputFile) {
        this.qalabMoversOutputFile = qalabMoversOutputFile;
    }

    public boolean isQuiet() {
        return this.quiet;
    }

    public void setQuiet(boolean quiet) {
        this.quiet = quiet;
    }

    public String getStartTimeHoursOffset() {
        return this.startTimeHoursOffset;
    }

    public void setStartTimeHoursOffset(String startTimeHoursOffset) {
        this.startTimeHoursOffset = startTimeHoursOffset;
    }

    public String getStartTimeWindow() {
        return this.startTimeWindow;
    }

    public void setStartTimeWindow(String startTimeWindow) {
        this.startTimeWindow = startTimeWindow;
    }

    public String getTypes() {
        return this.types;
    }

    public void setTypes(String types) {
        this.types = types;
    }

    public boolean isWeekendAdjustment() {
        return this.weekendAdjustment;
    }

    public void setWeekendAdjustment(boolean weekendAdjustment) {
        this.weekendAdjustment = weekendAdjustment;
    }
}

