/*
 * Decompiled with CFR 0.152.
 */
package net.objectlab.qalab.m2;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import net.objectlab.qalab.m2.util.Maven2TaskLogger;
import net.objectlab.qalab.m2.util.Utils;
import net.objectlab.qalab.parser.BuildStatForChartParser;
import net.objectlab.qalab.util.TaskLogger;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.Mojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class BuildStatChartMojo
extends AbstractMojo {
    private static final int DEFAULT_WIDTH = 750;
    private static final int DEFAULT_HEIGHT = 500;
    private File qalabFile = null;
    private File toDir = null;
    private boolean quiet = false;
    private int width = 750;
    private int height = 500;
    private int movingAverage = 0;
    private boolean summaryOnly = false;
    private String types = "checkstyle,pmd,findbugs,simian,pmd-cpd,cobertura-line,cobertura-branch";
    private String summaryTypes = "checkstyle,pmd,findbugs,simian,pmd-cpd";
    private String filePrefix = "";
    private String xAxisTitle = "Date";
    private String yAxisTitle = "Violation Count / Coverage Percent";
    private String xAxisSummaryTitle = "Date";
    private String yAxisSummaryTitle = "Violation Count";

    public final void execute() throws MojoExecutionException {
        this.validate();
        if (!this.quiet) {
            this.getLog().info((CharSequence)("QALab CHARTS ==> qalabFile='" + this.qalabFile.getPath() + "'"));
            this.getLog().info((CharSequence)("toDir='" + this.toDir.getPath()));
            this.getLog().info((CharSequence)("width='" + this.width + "' height='" + this.height + "' summaryOnly='" + this.isSummaryOnly() + "'"));
            this.getLog().info((CharSequence)("Types=" + this.types));
            this.getLog().info((CharSequence)("Summary Types=" + this.getSummaryTypes()));
            this.getLog().info((CharSequence)("File Prefix=" + this.getFilePrefix()));
        }
        this.generateCharts();
    }

    private void generateCharts() throws MojoExecutionException {
        BuildStatForChartParser myForChartParser = new BuildStatForChartParser((TaskLogger)new Maven2TaskLogger((Mojo)this));
        myForChartParser.setChartHeight(this.height);
        myForChartParser.setChartWidth(this.width);
        myForChartParser.setToDir(this.toDir.getAbsolutePath() + "/");
        myForChartParser.setMovingAverage(this.movingAverage);
        myForChartParser.setSummaryOnly(this.isSummaryOnly());
        myForChartParser.setAcceptedStyle(this.types);
        myForChartParser.setSummaryStyle(this.getSummaryTypes());
        myForChartParser.setQuiet(this.quiet);
        myForChartParser.setFilePrefix(this.getFilePrefix());
        myForChartParser.setXAxisSummaryTitle(this.xAxisSummaryTitle);
        myForChartParser.setXAxisTitle(this.xAxisTitle);
        myForChartParser.setYAxisSummaryTitle(this.yAxisSummaryTitle);
        myForChartParser.setYAxisTitle(this.yAxisTitle);
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            SAXParser saxParser = factory.newSAXParser();
            if (!this.quiet) {
                this.getLog().info((CharSequence)("Parsing " + this.qalabFile));
            }
            saxParser.parse(new InputSource(new FileInputStream(this.qalabFile)), (DefaultHandler)myForChartParser);
        }
        catch (SAXException sex) {
            this.getLog().error((CharSequence)sex.toString());
            throw new MojoExecutionException("Error generating charts.", (Exception)sex);
        }
        catch (FileNotFoundException fnfex) {
            this.getLog().error((CharSequence)fnfex.toString());
            throw new MojoExecutionException("Error generating charts.", (Exception)fnfex);
        }
        catch (IOException ioex) {
            this.getLog().error((CharSequence)ioex.toString());
            throw new MojoExecutionException("Error generating charts.", (Exception)ioex);
        }
        catch (ParserConfigurationException e) {
            this.getLog().error((CharSequence)e.toString());
            throw new MojoExecutionException("Error generating charts.", (Exception)e);
        }
    }

    private void validate() throws MojoExecutionException {
        try {
            Utils.checkFile(this.qalabFile, "qalabFile");
        }
        catch (IOException ioex) {
            throw new MojoExecutionException(ioex.getMessage(), (Exception)ioex);
        }
        if (this.toDir == null) {
            throw new MojoExecutionException("toDir is mandatory");
        }
        if (this.toDir.exists() && !this.toDir.isDirectory()) {
            String message = "toDir must be a directory (" + this.toDir + ")";
            throw new MojoExecutionException(message);
        }
        if (!this.toDir.exists()) {
            if (!this.quiet) {
                this.getLog().debug((CharSequence)("Creating directory: " + this.toDir.toString()));
            }
            this.toDir.mkdir();
        }
    }

    public boolean isSummaryOnly() {
        return this.summaryOnly;
    }

    public void setSummaryOnly(boolean summaryOnly) {
        this.summaryOnly = summaryOnly;
    }

    public String getSummaryTypes() {
        return this.summaryTypes;
    }

    public void setSummaryTypes(String summaryTypes) {
        this.summaryTypes = summaryTypes;
    }

    public String getFilePrefix() {
        return this.filePrefix;
    }

    public void setFilePrefix(String filePrefix) {
        this.filePrefix = filePrefix;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public int getMovingAverage() {
        return this.movingAverage;
    }

    public void setMovingAverage(int movingAverage) {
        this.movingAverage = movingAverage;
    }

    public File getQalabFile() {
        return this.qalabFile;
    }

    public void setQalabFile(File qalabFile) {
        this.qalabFile = qalabFile;
    }

    public boolean isQuiet() {
        return this.quiet;
    }

    public void setQuiet(boolean quiet) {
        this.quiet = quiet;
    }

    public File getToDir() {
        return this.toDir;
    }

    public void setToDir(File toDir) {
        this.toDir = toDir;
    }

    public String getTypes() {
        return this.types;
    }

    public void setTypes(String types) {
        this.types = types;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public void setXAxisSummaryTitle(String xAxisSummaryTitle) {
        this.xAxisSummaryTitle = xAxisSummaryTitle;
    }

    public void setXAxisTitle(String xAxisTitle) {
        this.xAxisTitle = xAxisTitle;
    }

    public void setYAxisSummaryTitle(String yAxisSummaryTitle) {
        this.yAxisSummaryTitle = yAxisSummaryTitle;
    }

    public void setYAxisTitle(String yAxisTitle) {
        this.yAxisTitle = yAxisTitle;
    }
}

