/*
 * Decompiled with CFR 0.152.
 */
package net.objectlab.qalab.ant;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import net.objectlab.qalab.ant.AntTaskLogger;
import net.objectlab.qalab.parser.BuildStatForChartParser;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class BuildStatChartTask
extends Task {
    private static final int DEFAULT_WIDTH = 950;
    private static final int DEFAULT_HEIGHT = 600;
    private File inputFile = null;
    private File toDir = null;
    private boolean quiet = false;
    private int width = 950;
    private int height = 600;
    private int movingAverage = 0;
    private boolean summaryOnly = true;
    private String type = "checkstyle";
    private String summaryType = "checkstyle";
    private String filePrefix = "";
    private String xAxisTitle = "Dates";
    private String yAxisTitle = "Violations";
    private String xAxisSummaryTitle = "Dates";
    private String yAxisSummaryTitle = "Violations";

    public final void execute() {
        this.validate();
        if (!this.quiet) {
            this.log("inputFile='" + this.inputFile.getPath() + "', toDir='" + this.toDir.getPath() + "'");
            this.log("width='" + this.width + "' height='" + this.height + "' summaryOnly='" + this.summaryOnly + "'");
            this.log("type='" + this.type + "' summaryType='" + this.summaryType + "'");
        }
        this.generateCharts();
    }

    private void generateCharts() {
        BuildStatForChartParser myForChartParser = new BuildStatForChartParser(new AntTaskLogger(this));
        myForChartParser.setChartHeight(this.getHeight());
        myForChartParser.setChartWidth(this.getWidth());
        myForChartParser.setToDir(this.toDir.getAbsolutePath() + "/");
        myForChartParser.setMovingAverage(this.movingAverage);
        myForChartParser.setSummaryOnly(this.summaryOnly);
        myForChartParser.setSummaryStyle(this.summaryType);
        myForChartParser.setAcceptedStyle(this.type);
        myForChartParser.setQuiet(this.quiet);
        myForChartParser.setFilePrefix(this.getFilePrefix());
        myForChartParser.setXAxisSummaryTitle(this.xAxisSummaryTitle);
        myForChartParser.setYAxisSummaryTitle(this.yAxisSummaryTitle);
        myForChartParser.setXAxisTitle(this.xAxisTitle);
        myForChartParser.setYAxisTitle(this.yAxisTitle);
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            SAXParser saxParser = factory.newSAXParser();
            if (!this.quiet) {
                this.log("Parsing " + this.inputFile);
            }
            saxParser.parse(new InputSource(new FileInputStream(this.inputFile)), (DefaultHandler)myForChartParser);
        }
        catch (SAXException e) {
            this.log(e.toString());
        }
        catch (FileNotFoundException e) {
            this.log(e.toString());
        }
        catch (IOException e) {
            this.log(e.toString());
        }
        catch (ParserConfigurationException e) {
            this.log(e.toString());
        }
    }

    private void validate() {
        if (this.inputFile == null) {
            throw new BuildException("inputFile is mandatory");
        }
        if (this.toDir == null) {
            throw new BuildException("toDir is mandatory");
        }
        if (!this.inputFile.canRead()) {
            String message = "Unable to read from " + this.inputFile + ".";
            throw new BuildException(message);
        }
        if (this.toDir.exists() && !this.toDir.isDirectory()) {
            String message = "toDir must be a directory (" + this.toDir + ")";
            throw new BuildException(message);
        }
        if (!this.toDir.exists()) {
            if (!this.quiet) {
                this.log("Creating directory: " + this.toDir.toString());
            }
            this.toDir.mkdir();
        }
    }

    public final void setType(String statisticsType) {
        this.type = statisticsType;
    }

    public final void setInputFile(File statisticsFile) {
        this.inputFile = statisticsFile;
    }

    public final void setToDir(File targetDirectory) {
        this.toDir = targetDirectory;
    }

    public final void setQuiet(boolean beQuiet) {
        this.quiet = beQuiet;
    }

    public final int getWidth() {
        return this.width;
    }

    public final void setWidth(int chartWidth) {
        this.width = chartWidth;
    }

    public final int getHeight() {
        return this.height;
    }

    public final void setHeight(int chartHeight) {
        this.height = chartHeight;
    }

    public final int getMovingAverage() {
        return this.movingAverage;
    }

    public final void setMovingAverage(int aMovingAverage) {
        this.movingAverage = aMovingAverage;
    }

    public final boolean isSummaryOnly() {
        return this.summaryOnly;
    }

    public final void setSummaryOnly(boolean onlySummary) {
        this.summaryOnly = onlySummary;
    }

    public final String getFilePrefix() {
        return this.filePrefix;
    }

    public final void setFilePrefix(String prefix) {
        this.filePrefix = prefix;
    }

    public String getSummaryType() {
        return this.summaryType;
    }

    public void setSummaryType(String theSummaryType) {
        this.summaryType = theSummaryType;
    }

    public String getXAxisSummaryTitle() {
        return this.xAxisSummaryTitle;
    }

    public void setXAxisSummaryTitle(String axisSummaryTitle) {
        this.xAxisSummaryTitle = axisSummaryTitle;
    }

    public String getXAxisTitle() {
        return this.xAxisTitle;
    }

    public void setXAxisTitle(String axisTitle) {
        this.xAxisTitle = axisTitle;
    }

    public String getYAxisSummaryTitle() {
        return this.yAxisSummaryTitle;
    }

    public void setYAxisSummaryTitle(String axisSummaryTitle) {
        this.yAxisSummaryTitle = axisSummaryTitle;
    }

    public String getYAxisTitle() {
        return this.yAxisTitle;
    }

    public void setYAxisTitle(String axisTitle) {
        this.yAxisTitle = axisTitle;
    }
}

