/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.experimental.chart.demo;

import java.awt.Dimension;
import java.awt.Window;
import javax.swing.JPanel;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import org.jfree.experimental.chart.axis.LogAxis;
import org.jfree.ui.ApplicationFrame;
import org.jfree.ui.RefineryUtilities;

public class LogAxisDemo1
extends ApplicationFrame {
    public LogAxisDemo1(String title) {
        super(title);
        JPanel chartPanel = LogAxisDemo1.createDemoPanel();
        chartPanel.setPreferredSize(new Dimension(500, 270));
        this.setContentPane(chartPanel);
    }

    private static JFreeChart createChart(XYDataset dataset) {
        JFreeChart chart = ChartFactory.createScatterPlot((String)"Log Axis Demo 1", (String)"X", (String)"Y", (XYDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
        XYPlot plot = (XYPlot)chart.getPlot();
        LogAxis xAxis = new LogAxis("X");
        LogAxis yAxis = new LogAxis("Y");
        plot.setDomainAxis((ValueAxis)xAxis);
        plot.setRangeAxis((ValueAxis)yAxis);
        return chart;
    }

    private static XYDataset createDataset() {
        XYSeries series = new XYSeries((Comparable)((Object)"Random Data"));
        series.add(1.0, 500.2);
        series.add(5.0, 694.1);
        series.add(4.0, 100.0);
        series.add(12.5, 734.4);
        series.add(17.3, 453.2);
        series.add(21.2, 500.2);
        series.add(21.9, 9005.5);
        series.add(25.6, 734.4);
        series.add(3000.0, 453.2);
        return new XYSeriesCollection(series);
    }

    public static JPanel createDemoPanel() {
        JFreeChart chart = LogAxisDemo1.createChart(LogAxisDemo1.createDataset());
        return new ChartPanel(chart);
    }

    public static void main(String[] args) {
        LogAxisDemo1 demo = new LogAxisDemo1("Log Axis Demo 1");
        demo.pack();
        RefineryUtilities.centerFrameOnScreen((Window)((Object)demo));
        demo.setVisible(true);
    }
}

