/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.experimental.chart.axis;

import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import org.jfree.chart.axis.Axis;
import org.jfree.chart.axis.AxisState;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.NumberTick;
import org.jfree.chart.axis.NumberTickUnit;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.event.AxisChangeEvent;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotRenderingInfo;
import org.jfree.chart.plot.ValueAxisPlot;
import org.jfree.data.Range;
import org.jfree.ui.RectangleEdge;
import org.jfree.ui.TextAnchor;

public class LogAxis
extends ValueAxis {
    private double base = 10.0;
    private double baseLog = Math.log(10.0);
    private double smallestValue = 1.0E-100;
    private NumberTickUnit tickUnit;
    private NumberFormat numberFormatOverride;
    private int minorTickCount;

    public LogAxis() {
        this(null);
    }

    public LogAxis(String label) {
        super(label, NumberAxis.createIntegerTickUnits());
        this.setDefaultAutoRange(new Range(0.01, 1.0));
        this.tickUnit = new NumberTickUnit(1.0);
        this.minorTickCount = 10;
        this.setTickMarksVisible(false);
    }

    public double getBase() {
        return this.base;
    }

    public void setBase(double base) {
        if (base <= 1.0) {
            throw new IllegalArgumentException("Requires 'base' > 1.0.");
        }
        this.base = base;
        this.baseLog = Math.log(base);
        this.notifyListeners(new AxisChangeEvent((Axis)this));
    }

    public double getSmallestValue() {
        return this.smallestValue;
    }

    public void setSmallestValue(double value) {
        if (value <= 0.0) {
            throw new IllegalArgumentException("Requires 'value' > 0.0.");
        }
        this.smallestValue = value;
    }

    public NumberTickUnit getTickUnit() {
        return this.tickUnit;
    }

    public void setTickUnit(NumberTickUnit unit) {
        this.setTickUnit(unit, true, true);
    }

    public void setTickUnit(NumberTickUnit unit, boolean notify, boolean turnOffAutoSelect) {
        if (unit == null) {
            throw new IllegalArgumentException("Null 'unit' argument.");
        }
        this.tickUnit = unit;
        if (turnOffAutoSelect) {
            this.setAutoTickUnitSelection(false, false);
        }
        if (notify) {
            this.notifyListeners(new AxisChangeEvent((Axis)this));
        }
    }

    public NumberFormat getNumberFormatOverride() {
        return this.numberFormatOverride;
    }

    public void setNumberFormatOverride(NumberFormat formatter) {
        this.numberFormatOverride = formatter;
        this.notifyListeners(new AxisChangeEvent((Axis)this));
    }

    public int getMinorTickCount() {
        return this.minorTickCount;
    }

    public void setMinorTickCount(int count) {
        if (count <= 0) {
            throw new IllegalArgumentException("Requires 'count' > 0.");
        }
        this.minorTickCount = count;
        this.notifyListeners(new AxisChangeEvent((Axis)this));
    }

    public double calculateLog(double value) {
        return Math.log(value) / this.baseLog;
    }

    public double calculateValue(double log) {
        return Math.pow(this.base, log);
    }

    public double java2DToValue(double java2DValue, Rectangle2D area, RectangleEdge edge) {
        Range range = this.getRange();
        double axisMin = this.calculateLog(range.getLowerBound());
        double axisMax = this.calculateLog(range.getUpperBound());
        double min = 0.0;
        double max = 0.0;
        if (RectangleEdge.isTopOrBottom((RectangleEdge)edge)) {
            min = area.getX();
            max = area.getMaxX();
        } else if (RectangleEdge.isLeftOrRight((RectangleEdge)edge)) {
            min = area.getMaxY();
            max = area.getY();
        }
        double log = 0.0;
        log = this.isInverted() ? axisMax - (java2DValue - min) / (max - min) * (axisMax - axisMin) : axisMin + (java2DValue - min) / (max - min) * (axisMax - axisMin);
        return this.calculateValue(log);
    }

    public double valueToJava2D(double value, Rectangle2D area, RectangleEdge edge) {
        Range range = this.getRange();
        double axisMin = this.calculateLog(range.getLowerBound());
        double axisMax = this.calculateLog(range.getUpperBound());
        value = this.calculateLog(value);
        double min = 0.0;
        double max = 0.0;
        if (RectangleEdge.isTopOrBottom((RectangleEdge)edge)) {
            min = area.getX();
            max = area.getMaxX();
        } else if (RectangleEdge.isLeftOrRight((RectangleEdge)edge)) {
            max = area.getMinY();
            min = area.getMaxY();
        }
        if (this.isInverted()) {
            return max - (value - axisMin) / (axisMax - axisMin) * (max - min);
        }
        return min + (value - axisMin) / (axisMax - axisMin) * (max - min);
    }

    public void configure() {
        if (this.isAutoRange()) {
            this.autoAdjustRange();
        }
    }

    protected void autoAdjustRange() {
        Plot plot = this.getPlot();
        if (plot == null) {
            return;
        }
        if (plot instanceof ValueAxisPlot) {
            ValueAxisPlot vap = (ValueAxisPlot)plot;
            Range r = vap.getDataRange((ValueAxis)this);
            if (r == null) {
                r = this.getDefaultAutoRange();
            }
            double upper = r.getUpperBound();
            double lower = r.getLowerBound();
            double range = upper - lower;
            double fixedAutoRange = this.getFixedAutoRange();
            if (fixedAutoRange > 0.0) {
                lower = Math.max(upper - fixedAutoRange, this.smallestValue);
            } else {
                double minRange = this.getAutoRangeMinimumSize();
                if (range < minRange) {
                    double expand = (minRange - range) / 2.0;
                    upper += expand;
                    lower -= expand;
                }
            }
            this.setRange(new Range(lower, upper), false, false);
        }
    }

    public AxisState draw(Graphics2D g2, double cursor, Rectangle2D plotArea, Rectangle2D dataArea, RectangleEdge edge, PlotRenderingInfo plotState) {
        AxisState state = null;
        if (!this.isVisible()) {
            state = new AxisState(cursor);
            List ticks = this.refreshTicks(g2, state, dataArea, edge);
            state.setTicks(ticks);
            return state;
        }
        state = this.drawTickMarksAndLabels(g2, cursor, plotArea, dataArea, edge);
        state = this.drawLabel(this.getLabel(), g2, plotArea, dataArea, edge, state);
        return state;
    }

    public List refreshTicks(Graphics2D g2, AxisState state, Rectangle2D dataArea, RectangleEdge edge) {
        List result = new ArrayList();
        if (RectangleEdge.isTopOrBottom((RectangleEdge)edge)) {
            result = this.refreshTicksHorizontal(g2, dataArea, edge);
        } else if (RectangleEdge.isLeftOrRight((RectangleEdge)edge)) {
            result = this.refreshTicksVertical(g2, dataArea, edge);
        }
        return result;
    }

    protected List refreshTicksHorizontal(Graphics2D g2, Rectangle2D dataArea, RectangleEdge edge) {
        Range range = this.getRange();
        ArrayList<NumberTick> ticks = new ArrayList<NumberTick>();
        double start = Math.floor(this.calculateLog(this.getLowerBound()));
        double end = Math.ceil(this.calculateLog(this.getUpperBound()));
        for (double current = start; current <= end; current += this.tickUnit.getSize()) {
            double v = this.calculateValue(current);
            if (range.contains(v)) {
                ticks.add(new NumberTick((Number)new Double(v), this.createTickLabel(v), TextAnchor.TOP_CENTER, TextAnchor.CENTER, 0.0));
            }
            double next = Math.pow(this.base, current + this.tickUnit.getSize());
            for (int i = 1; i < this.minorTickCount; ++i) {
                double minorV = v + (double)i * ((next - v) / (double)this.minorTickCount);
                if (!range.contains(minorV)) continue;
                ticks.add(new NumberTick((Number)new Double(minorV), "", TextAnchor.TOP_CENTER, TextAnchor.CENTER, 0.0));
            }
        }
        return ticks;
    }

    protected List refreshTicksVertical(Graphics2D g2, Rectangle2D dataArea, RectangleEdge edge) {
        Range range = this.getRange();
        ArrayList<NumberTick> ticks = new ArrayList<NumberTick>();
        double start = Math.floor(this.calculateLog(this.getLowerBound()));
        double end = Math.ceil(this.calculateLog(this.getUpperBound()));
        for (double current = start; current <= end; current += this.tickUnit.getSize()) {
            double v = this.calculateValue(current);
            if (range.contains(v)) {
                ticks.add(new NumberTick((Number)new Double(v), this.createTickLabel(v), TextAnchor.CENTER_RIGHT, TextAnchor.CENTER, 0.0));
            }
            double next = Math.pow(this.base, current + this.tickUnit.getSize());
            for (int i = 1; i < this.minorTickCount; ++i) {
                double minorV = v + (double)i * ((next - v) / (double)this.minorTickCount);
                if (!range.contains(minorV)) continue;
                ticks.add(new NumberTick((Number)new Double(minorV), "", TextAnchor.CENTER_RIGHT, TextAnchor.CENTER, 0.0));
            }
        }
        return ticks;
    }

    private String createTickLabel(double value) {
        if (this.numberFormatOverride != null) {
            return this.numberFormatOverride.format(value);
        }
        return this.tickUnit.valueToString(value);
    }
}

