/*
 * Decompiled with CFR 0.152.
 */
package net.objectlab.qalab.parser;

import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import net.objectlab.qalab.parser.SingleStat;
import net.objectlab.qalab.util.QALabTags;

public class FileStats {
    private static final int ONE_DAY = 24;
    private Date startDateCutoff;
    private Date endDateCutoff = null;
    private StringBuffer upBuf = new StringBuffer();
    private StringBuffer downBuf = new StringBuffer();
    private String filename;
    private String pathToFile;
    private Map typesSurveyed;
    private int offsetForLastRun = 24;

    public FileStats(Map types, String fileSurveyed, String pathToFile, Date cutoff) {
        this.typesSurveyed = types;
        this.filename = fileSurveyed;
        this.pathToFile = pathToFile;
        this.startDateCutoff = new Date(cutoff.getTime());
    }

    public final String getFileName() {
        return this.filename;
    }

    public final String getUpXmlResult() {
        return this.upBuf.toString();
    }

    public final String getDownXmlResult() {
        return this.downBuf.toString();
    }

    public final void constructXML() {
        Set keys = this.typesSurveyed.keySet();
        Iterator i = keys.iterator();
        while (i.hasNext()) {
            Stack s = (Stack)this.typesSurveyed.get((String)i.next());
            this.processFilesResultBeans(s);
        }
        if (this.upBuf.length() > 0) {
            this.upBuf.insert(0, "  <file name=\"" + this.getFileName() + "\" path=\"" + this.getPathToFile() + "\">" + QALabTags.LINE_END);
            this.upBuf.append("  </file>").append(QALabTags.LINE_END);
        }
        if (this.downBuf.length() > 0) {
            this.downBuf.insert(0, "  <file name=\"" + this.getFileName() + "\" path=\"" + this.getPathToFile() + "\">" + QALabTags.LINE_END);
            this.downBuf.append("  </file>").append(QALabTags.LINE_END);
        }
    }

    private void processFilesResultBeans(Stack stack) {
        if (stack.empty()) {
            return;
        }
        SingleStat currentResult = (SingleStat)stack.pop();
        Iterator it = stack.iterator();
        Calendar currentday = Calendar.getInstance();
        currentday.setTime(this.getEndDateCutoff());
        currentday.add(10, -this.offsetForLastRun);
        if (!currentResult.getDate().before(this.startDateCutoff) && currentResult.getDate().before(currentday.getTime())) {
            this.appendStats(this.downBuf, currentResult, null);
        }
        this.checkPreviousResults(stack, currentResult, it);
    }

    private void checkPreviousResults(Stack stack, SingleStat currentResult, Iterator it) {
        Calendar oneDayBeforeEndCutoff = Calendar.getInstance();
        oneDayBeforeEndCutoff.setTime(this.endDateCutoff);
        oneDayBeforeEndCutoff.add(10, -this.offsetForLastRun);
        while (it.hasNext()) {
            SingleStat previousResult = (SingleStat)stack.pop();
            int previousCount = previousResult.getStatValue();
            int currentCount = currentResult.getStatValue();
            int diff = currentCount - previousCount;
            if (diff > 0) {
                this.handleUp(currentResult, previousResult);
            } else if (diff < 0) {
                this.handleDown(currentResult, previousResult);
            } else if (diff == 0 && this.fallInWindow(currentResult) && !currentResult.getDate().before(oneDayBeforeEndCutoff.getTime()) && !previousResult.getDate().after(this.startDateCutoff)) {
                this.appendStats(this.upBuf, null, currentResult);
            }
            currentResult = previousResult;
        }
        if (this.fallInWindow(currentResult)) {
            this.appendStats(this.upBuf, null, currentResult);
        }
    }

    private void handleDown(SingleStat currentResult, SingleStat previousResult) {
        if (this.fallInWindow(currentResult)) {
            this.appendStats(this.downBuf, previousResult, currentResult);
        }
    }

    private void handleUp(SingleStat currentResult, SingleStat previousResult) {
        if (this.fallInWindow(currentResult)) {
            this.appendStats(this.upBuf, previousResult, currentResult);
        }
    }

    private boolean fallInWindow(SingleStat stat) {
        return !stat.getDate().before(this.startDateCutoff) && !stat.getDate().after(this.endDateCutoff);
    }

    private void appendStats(StringBuffer buffer, SingleStat previousResult, SingleStat currentResult) {
        int diff;
        int previousCount = 0;
        if (previousResult != null) {
            previousCount = previousResult.getStatValue();
        }
        int currentCount = 0;
        if (currentResult != null) {
            currentCount = currentResult.getStatValue();
        }
        if ((diff = currentCount - previousCount) != 0) {
            buffer.append("   <diff previousrun=\"");
            if (previousResult != null) {
                this.writeDate(buffer, previousResult);
            } else {
                buffer.append("-");
            }
            buffer.append("\" currentrun=\"");
            if (currentResult != null) {
                this.writeDate(buffer, currentResult);
                buffer.append("\" type=\"").append(currentResult.getType());
            } else {
                buffer.append("-");
                buffer.append("\" type=\"").append(previousResult.getType());
            }
            buffer.append("\" previouserrors=\"");
            buffer.append(previousCount);
            buffer.append("\" currenterrors=\"");
            buffer.append(currentCount);
            buffer.append("\" diff=\"");
            buffer.append(diff);
            buffer.append("\"/>").append(QALabTags.LINE_END);
        }
    }

    private void writeDate(StringBuffer buffer, SingleStat currentResult) {
        Date date = currentResult.getDate();
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        if (0 == cal.get(13) && 0 == cal.get(12) && 0 == cal.get(10)) {
            buffer.append(QALabTags.DEFAULT_DATE_FORMAT.format(currentResult.getDate()));
        } else {
            buffer.append(QALabTags.DEFAULT_DATETIME_FORMAT.format(currentResult.getDate()));
        }
    }

    public final void setEndDateCutoff(Date endDate) {
        this.endDateCutoff = new Date(endDate.getTime());
    }

    public final Date getEndDateCutoff() {
        return new Date(this.endDateCutoff.getTime());
    }

    public final String getPathToFile() {
        return this.pathToFile;
    }

    public final void setPathToFile(String pathToFile) {
        this.pathToFile = pathToFile;
    }

    public int getOffsetForLastRun() {
        return this.offsetForLastRun;
    }

    public void setOffsetForLastRun(int offsetForLastRun) {
        this.offsetForLastRun = offsetForLastRun;
    }
}

