/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.experimental.chart.demo;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Point;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.Plot;
import org.jfree.data.general.DefaultValueDataset;
import org.jfree.data.general.ValueDataset;
import org.jfree.experimental.chart.plot.dial.DialBackground;
import org.jfree.experimental.chart.plot.dial.DialCap;
import org.jfree.experimental.chart.plot.dial.DialPlot;
import org.jfree.experimental.chart.plot.dial.DialPointer;
import org.jfree.experimental.chart.plot.dial.DialTextAnnotation;
import org.jfree.experimental.chart.plot.dial.DialValueIndicator;
import org.jfree.experimental.chart.plot.dial.SimpleDialFrame;
import org.jfree.experimental.chart.plot.dial.StandardDialRange;
import org.jfree.experimental.chart.plot.dial.StandardDialScale;
import org.jfree.ui.GradientPaintTransformType;
import org.jfree.ui.GradientPaintTransformer;
import org.jfree.ui.StandardGradientPaintTransformer;

public class DialDemo1
extends JFrame
implements ChangeListener {
    JSlider slider;
    DefaultValueDataset dataset = new DefaultValueDataset(10.0);

    public DialDemo1(String title) {
        super(title);
        DialPlot plot = new DialPlot();
        plot.setView(0.0, 0.0, 1.0, 1.0);
        plot.setDataset((ValueDataset)this.dataset);
        SimpleDialFrame dialFrame = new SimpleDialFrame();
        dialFrame.setBackgroundPaint(Color.lightGray);
        dialFrame.setForegroundPaint(Color.darkGray);
        plot.setDialFrame(dialFrame);
        GradientPaint gp = new GradientPaint(new Point(), new Color(255, 255, 255), new Point(), new Color(170, 170, 220));
        DialBackground db = new DialBackground(gp);
        db.setGradientPaintTransformer((GradientPaintTransformer)new StandardGradientPaintTransformer(GradientPaintTransformType.VERTICAL));
        plot.setBackground(db);
        DialTextAnnotation annotation1 = new DialTextAnnotation("Temperature");
        annotation1.setFont(new Font("Dialog", 1, 14));
        annotation1.setRadius(0.7);
        plot.addLayer(annotation1);
        DialValueIndicator dvi = new DialValueIndicator(0, "c");
        plot.addLayer(dvi);
        StandardDialScale scale = new StandardDialScale(-40.0, 60.0, -120.0, -300.0);
        scale.setTickRadius(0.88);
        scale.setTickLabelOffset(0.15);
        scale.setTickLabelFont(new Font("Dialog", 0, 14));
        plot.addScale(0, scale);
        StandardDialRange range = new StandardDialRange(40.0, 60.0, Color.red);
        range.setInnerRadius(0.52);
        range.setOuterRadius(0.55);
        plot.addLayer(range);
        StandardDialRange range2 = new StandardDialRange(10.0, 40.0, Color.orange);
        range2.setInnerRadius(0.52);
        range2.setOuterRadius(0.55);
        plot.addLayer(range2);
        StandardDialRange range3 = new StandardDialRange(-40.0, 10.0, Color.green);
        range3.setInnerRadius(0.52);
        range3.setOuterRadius(0.55);
        plot.addLayer(range3);
        DialPointer.Pointer needle = new DialPointer.Pointer();
        plot.addLayer(needle);
        DialCap cap = new DialCap();
        cap.setRadius(0.1);
        plot.setCap(cap);
        JFreeChart chart1 = new JFreeChart((Plot)plot);
        chart1.setTitle("Demo Dial 1");
        ChartPanel cp1 = new ChartPanel(chart1);
        cp1.setPreferredSize(new Dimension(400, 400));
        this.slider = new JSlider(-40, 60);
        this.slider.setMajorTickSpacing(10);
        this.slider.setPaintLabels(true);
        this.slider.addChangeListener(this);
        JPanel content = new JPanel(new BorderLayout());
        content.add((Component)cp1);
        content.add((Component)this.slider, "South");
        this.setDefaultCloseOperation(3);
        this.setContentPane(content);
    }

    public void stateChanged(ChangeEvent e) {
        this.dataset.setValue((Number)new Integer(this.slider.getValue()));
    }

    public static void main(String[] args) {
        DialDemo1 app = new DialDemo1("JFreeChart - Demo Dial 1");
        app.pack();
        app.setVisible(true);
    }
}

