/* 
 * Copyright (c) 1994-1995 Sun Microsystems, Inc. All Rights Reserved.
 *
 * Permission to use, copy, modify, and distribute this software
 * and its documentation for NON-COMMERCIAL or COMMERCIAL purposes and
 * without fee is hereby granted.
 * Please refer to the file http://java.sun.com/copy_trademarks.html
 * for further important copyright and trademark information and to
 * http://java.sun.com/licensing.html for further important licensing
 * information for the Java (tm) Technology.
 *
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF
 * THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
 * TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
 * PARTICULAR PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR
 * ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR
 * DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.
 *
 * THIS SOFTWARE IS NOT DESIGNED OR INTENDED FOR USE OR RESALE AS ON-LINE
 * CONTROL EQUIPMENT IN HAZARDOUS ENVIRONMENTS REQUIRING FAIL-SAFE
 * PERFORMANCE, SUCH AS IN THE OPERATION OF NUCLEAR FACILITIES, AIRCRAFT
 * NAVIGATION OR COMMUNICATION SYSTEMS, AIR TRAFFIC CONTROL, DIRECT LIFE
 * SUPPORT MACHINES, OR WEAPONS SYSTEMS, IN WHICH THE FAILURE OF THE
 * SOFTWARE COULD LEAD DIRECTLY TO DEATH, PERSONAL INJURY, OR SEVERE
 * PHYSICAL OR ENVIRONMENTAL DAMAGE ("HIGH RISK ACTIVITIES").  SUN
 * SPECIFICALLY DISCLAIMS ANY EXPRESS OR IMPLIED WARRANTY OF FITNESS FOR
 * HIGH RISK ACTIVITIES.
 */

import java.lang.*; 
import java.awt.*;
import java.net.*;
import java.util.*;
 
/**
 * contains lines and draws these lines in the given display
 *
 * @author      Siebe R. Brouwer
 * version      1.1, 13 october 1995
 */

class LineDiagram extends Diagram {
    
    protected Display display;
    protected int virtualYgap;
    protected int virtualXgap;
    protected int virtualXbegin;
    protected int virtualYbegin;
    protected int xBegin;
    protected int yBegin;
    protected Vector lines;
        
    // constructor of this class
    LineDiagram(int vXbegin, int vYbegin, int vXgap, int vYgap, Display d) {
        display = d;
	float i = (float)vXbegin / (float)vXgap;
	xBegin = (int)(i * display.xGap());
	i = (float)vYbegin / (float)vYgap;
	yBegin = (int)(i * display.yGap());
        virtualXbegin = vXbegin;
	virtualYbegin = vYbegin;
        virtualXgap = vXgap;
	virtualYgap = vYgap;
	lines = new Vector();
    }
    
    // create a new line for in the diagram
    public void createLine(Color color, String label) {
	if(!hasLine(label)) {		 	 	
    	    lines.addElement(new Line(color, label));	
	}
    }  
    
    // add dot to current line
    public void addDot(int x, int y, String label, String lineLabel) {
    	if(hasLine(lineLabel)) {
	    int index = getLine(lineLabel);
	    Line line = (Line)lines.elementAt(index);
	    int xValue = convertXdot(x);
	    int yValue = convertYdot(y);
	    line.addDot(xValue, yValue, label);
    
	}
    }
    
    // draw the lines who are in the diagram
    public void drawData(Graphics g, int gaps, int left, int moved) { 
	int xStart = display.xStart();
	int yStart = display.yStart();
	int xTop = display.xTop();
	int yTop = display.yTop();
	int xGap = display.xGap();
	int yGap = display.yGap();
	
	int vGap=0;
	int vXrest=0;
	int vXgap=0;
	int vXbegin=0;
	int firstGap=0;
	int vFirstGap=0;
	int vYgap = virtualYbegin;
	
	if(gaps == 0 && left == 0) { 
	    firstGap = xGap;
	    vXbegin = virtualXbegin;
	    vFirstGap= virtualXbegin + virtualXgap;
	}
	else if(gaps < 0 || left < 0) {
	    float value = ((left == 0)?0:(float)left /(float)xGap);
	    vGap = (int)(value * (float)virtualXgap);
	    vXgap = gaps * virtualXgap;
	    vXbegin = virtualXbegin - (vGap + vXgap);
	    firstGap = xGap + left;
	    vFirstGap = vXbegin + (virtualXgap + vGap);
	}
	
	else if(gaps > 0 || left > 0) {
	    float value = ((left == 0)?0 : (float)left / (float)xGap);
	    vGap = (int)(value * (float)virtualXgap);
	    vXgap = gaps * virtualXgap;
	    vXbegin = virtualXbegin - (vGap + vXgap);
	    firstGap = left;
	    vFirstGap = vXbegin+ vGap;
	}   
	if(left == 0) {
	    g.drawString(Integer.toString(vXbegin), xStart, yStart + 15);
	}
	for(int i = firstGap +xStart; i <= xTop; i += xGap) {
	    g.drawString(Integer.toString(vFirstGap), i, yStart + 15);
	    vFirstGap += virtualXgap;
	}
	for(int i = yStart; i >= yTop; i -= yGap) {
	    g.drawString(Integer.toString(vYgap), xStart - 40, i);
	    vYgap += virtualYgap;
	}	
	int xIndex = xTop - ((xTop - xStart) / 3);
	int yIndex=50;
	g.setColor(Color.black);
	g.drawString("INDEX",xIndex, yIndex);
	yIndex += 5;
	g.drawLine(xIndex, yIndex, xIndex + 30, yIndex);
	for(Enumeration e = lines.elements();e.hasMoreElements() ; ) {
	    yIndex += 15;
	    Line line = (Line)e.nextElement();
            line.drawIndex(g, xIndex, yIndex); 	    
	    line.drawLine(g, moved, xStart, yStart, xTop, yTop);
	}
    }
    
    // give true if there is a line with the desired label
    protected boolean hasLine(String label) {
	for(Enumeration e = lines.elements();e.hasMoreElements() ; ) {
	    Line line= (Line)e.nextElement();
            if (line.label() == label) {
	 
		return true;
	    }
	}
	
	return false;
    }
    
    // get the line with the label
    protected int getLine(String label) {
	for(Enumeration e = lines.elements();e.hasMoreElements() ; ) {
	    Line line = (Line)e.nextElement();
            if (line.label() == label) {
	   	return lines.indexOf(line);
	    }
	}
    	return -1;    	
    }
    
    /* convert i to an integer value, the value represents the distance
     * from the xStart to the y value of the dot
     */
    protected int convertXdot(int i) {
	int xGap = display.xGap();
	float virtual = (float)i / (float)virtualXgap;
	int virtual2 =(int)(virtual * xGap);
	return virtual2 - xBegin;
    }
    
    /* convert i to an integer value, the value represents the disctance	
     * from yStart to the y value of the dot
     */
    protected int convertYdot(int i) {
    	int yGap = display.yGap();
	float virtual = (float)i / (float)virtualYgap;
	virtual = virtual * yGap;
	return (int)(virtual - yBegin);
    }
}

// class line
class Line {
    
    protected int type;
    public Color color;
    protected String label;
    protected Vector dots;
    
    // constructor
    Line(Color c, String l) {
	label = l;
    	color = c;
	dots = new Vector();
    }

    // draw the dots and the lines between the dots to the graphics object
    public void drawLine(Graphics g, int moved, int xS, int yS, int xT, int yT) {
    	Dot dot;
	int xReal=0;
	int yReal=0;
	int prevXreal= 0;
	int prevYreal = 0;
	
	Graphics graphics = g.create();
	graphics.clipRect(xS + 1, yT, xT - xS, yS - yT);
	boolean drawLine = false;
	for(Enumeration e = dots.elements();e.hasMoreElements() ; ) {
	    dot = (Dot)e.nextElement();
	    xReal = (xS + dot.xValue()) + moved;
	    yReal = yS - dot.yValue();
	    if(drawLine) {
		graphics.drawLine(prevXreal, prevYreal, xReal, yReal);
	    }
	    graphics.setColor(color);
	    graphics.drawOval(xReal, yReal, 2, 2);
	    graphics.fillOval(xReal, yReal, 2, 2);
	    graphics.drawString(dot.label(), xReal, yReal - 3);
	    drawLine = true;
	    prevXreal = xReal;
	    prevYreal = yReal;
        }    
    }
    
    // draw the index of this line to the graphics object
    public void drawIndex(Graphics g, int x, int y) {	
	g.setColor(Color.black);
	g.drawRect(x,y,5,5);
	g.setColor(color);
	g.fillRect(x+1,y+1,4,4);
	g.setColor(Color.black);
	g.drawString(label, x+10,y+5);
    }
	
    /* create a new dot object and at him to the list of dots,
     * the dots in the list are stored in order of there xValue
     */
    public void addDot(int x, int y, String label) {
	Dot dot;
      	Enumeration e;
	for(e = dots.elements();e.hasMoreElements() ; ) {
	    dot = (Dot)e.nextElement();
            if(x < dot.xValue()) {
		int index = dots.indexOf(dot);
		dots.insertElementAt(new Dot(x,y,label), index);
		break;
	    }
	    else if(x == dot.xValue()) {
		break;
	    }
	}
	if(! e.hasMoreElements()|| dots.isEmpty()) {
	    dots.addElement(new Dot(x,y,label));
	}
    }
    
    // return the label of this line
    public String label() {
	return label;
    }
    
    // return the color of this line
    public Color color() {
    	return color;
    }
}

// class dot
class Dot {	
    protected int xValue;
    protected int yValue;
    protected String label;

    // constructor 
    Dot(int x, int y, String l) {
	xValue = x;
	yValue = y;
	label = l;
    }
    
    // return the xValue
    public int xValue() {
    	return xValue;
    }
    
    // return the yValue
    public int yValue() {
    	return yValue;
    }
    
    // return the label
    public String label() {
    	return label;
    }
}

