/* 
 * Copyright (c) 1994-1995 Sun Microsystems, Inc. All Rights Reserved.
 *
 * Permission to use, copy, modify, and distribute this software
 * and its documentation for NON-COMMERCIAL or COMMERCIAL purposes and
 * without fee is hereby granted.
 * Please refer to the file http://java.sun.com/copy_trademarks.html
 * for further important copyright and trademark information and to
 * http://java.sun.com/licensing.html for further important licensing
 * information for the Java (tm) Technology.
 *
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF
 * THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
 * TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
 * PARTICULAR PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR
 * ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR
 * DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.
 *
 * THIS SOFTWARE IS NOT DESIGNED OR INTENDED FOR USE OR RESALE AS ON-LINE
 * CONTROL EQUIPMENT IN HAZARDOUS ENVIRONMENTS REQUIRING FAIL-SAFE
 * PERFORMANCE, SUCH AS IN THE OPERATION OF NUCLEAR FACILITIES, AIRCRAFT
 * NAVIGATION OR COMMUNICATION SYSTEMS, AIR TRAFFIC CONTROL, DIRECT LIFE
 * SUPPORT MACHINES, OR WEAPONS SYSTEMS, IN WHICH THE FAILURE OF THE
 * SOFTWARE COULD LEAD DIRECTLY TO DEATH, PERSONAL INJURY, OR SEVERE
 * PHYSICAL OR ENVIRONMENTAL DAMAGE ("HIGH RISK ACTIVITIES").  SUN
 * SPECIFICALLY DISCLAIMS ANY EXPRESS OR IMPLIED WARRANTY OF FITNESS FOR
 * HIGH RISK ACTIVITIES.
 */
import java.lang.*; 
import java.io.*;
import java.awt.*;
import java.net.*;
import java.applet.*;
import java.util.*;
import Display;
 
/**
 * 
 *
 * @author      Siebe R. Brouwer
 * version      1.1, 13 october 1995
 */

public class BarApplet extends Applet {
    protected Display display;
    protected BarDiagram diagram;
    
    public void init() {
	
	String at = getParameter("filename");
	String fileName = (at != null) ? at : "bars.data";
	at = getParameter("dir");
	String dir = (at != null) ? at : "dataFiles/";
	at = getParameter("header");
	String header = (at != null) ? at : "BAR DIAGRAM";
	at = getParameter("xtext");
	String xText = (at != null) ? at : "x-axis";
	at = getParameter("yText");
	String yText = (at != null) ? at : "y-axis";
	at = getParameter("vybegin");
	int vYbegin = (at != null) ? Integer.valueOf(at).intValue() :0;
	at = getParameter("vygap");
	int vYgap = (at != null) ? Integer.valueOf(at).intValue() : 100;
	at = getParameter("xgap");
	int xGap = (at != null) ? Integer.valueOf(at).intValue() : 50;
	at = getParameter("ygap");
        int yGap = (at != null) ? Integer.valueOf(at).intValue() : 50;
        setLayout(new BorderLayout());
	display = new Display(header,xText, yText, xGap, yGap);
	add("Center",display);	
	
        // create a bardiagram with the specific variables
	diagram = new BarDiagram(display,vYbegin,vYgap);
	
        runDiagram(fileName, dir);
    
    }
    // read the input file and generate the diagram
    public void runDiagram(String fileName,String dir) {
	
	String field;
	int state;
	String line;
	int number;
	Vector fields= new Vector();
	
	URL url = new URL(getDocumentBase(), dir + fileName);
	DataInputStream file = new DataInputStream(url.openStream());
	
        line=nextLine(file);
	state = Integer.valueOf(line).intValue(); 
	// read the fields in
	for(int i = 0; i <state;i++) {
	    field=nextLine(file);
	    fields.addElement(field);
	    diagram.addField(field);	
	}
	
	line=nextLine(file);
	state = Integer.valueOf(line).intValue();
	
        // read the index labels with their color
	int nrOfFields = fields.size();
	int c[] = new int[3];
	int d[] = new int[nrOfFields];
	StringTokenizer t;
	for(int i = 0; i < state; i++) {
	    String index = nextLine(file);
	    line=nextLine(file);
	    t= new StringTokenizer(line,",");
	    String n=null;
	    int j = 0;
	    while(t.hasMoreTokens()) {
	    	n = t.nextToken().trim();
		c[j] = Integer.valueOf(n).intValue();	
		j++;
	    }
            line=nextLine(file);
	    t = new StringTokenizer(line,",");
            j = 0;
	    while(t.hasMoreTokens()) {
		n = t.nextToken().trim();
		d[j] = Integer.valueOf(n).intValue();	
		j++;
	    }
	    Color color = new Color(c[0], c[1], c[2]);
	    diagram.addIndex(index, color);
	    for(int k = 0; k <nrOfFields;k++) {
		diagram.addValue(d[k],index,(String)fields.elementAt(k));
	    }
	}
	display.drawDiagram(diagram);
    }
     
    /* return the next usable line
     * 
     */
    protected String nextLine(DataInputStream file) {
	String line = file.readLine().trim();
	while(line.startsWith("#") || line.length() == 0) {
	    line = file.readLine().trim();
	}
	return line;
    }
}




