package r08.r08_06;

import java.io.*;
import java.nio.charset.*;
import java.nio.file.*;
import java.util.*;
import java.util.stream.*;

public class SimpleReductions {
    public static void main(String[] args) throws IOException {
        String contents = new String(Files.readAllBytes(Paths.get("zemsta.txt")),
                StandardCharsets.UTF_8);
        List<String> sowa = Arrays.asList(contents.split("\\PL+"));

        Optional<String> najdusze = sowa.stream().max(String::compareToIgnoreCase);
        System.out.println("najdusze: " + najdusze.orElse(""));

        boolean sowoZaczynajceSiOdQ = sowa.stream().anyMatch(s -> s.startsWith("Q"));
        System.out.println("sowoZaczynajceSiOdQ: " + sowoZaczynajceSiOdQ);

        Optional<String> zaczynaSiOdQ = sowa.stream().parallel().filter(s -> s.startsWith("Q")).findAny();
        System.out.println("zaczynaSiOdQ: " + zaczynaSiOdQ.orElse("(None)"));
            // Uruchom program jeszcze raz by sprawdzi czy znajdzie inne sowo
    }
}
