package r09.r09_01;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

public class CharsetDemo {
    public static void main(String[] args) {
        System.out.println("Domylny zestaw znakw na tym komputerze: " + Charset.defaultCharset());
        System.out.println("Zestawy znakw dostpne w JVM: " + Charset.availableCharsets().keySet());
        
        String str = "Java\u2122";
        System.out.println(str);
        byte[] bytes = str.getBytes(StandardCharsets.UTF_8);
        showBytes(bytes);
            // Zauwa,  oznaczenie marki chronionej zajmuje trzy bajty
        showBytes(str.getBytes(StandardCharsets.UTF_16));
            // Zauwa znacznik kolejnoci bajtw
        showBytes(str.getBytes(StandardCharsets.ISO_8859_1));
            // Znak TM nie moe by zakodowany i jest zastpowany znakiem ?
        
        System.out.println(new String(bytes, Charset.forName("windows-1252")));
            // Skd wiesz, e to ze kodowanie? Jak moe to stwierdzi program?
    }
    
    public static void showBytes(byte[] bytes) {
        for (byte b : bytes) System.out.printf("%2X ", b);
        System.out.println();
    }
}
