package r11.r11_04;

import java.lang.reflect.Field;

public class ToStrings {
    public static String toString(Object obj) {
        if (obj == null) return "null";
        Class<?> cl = obj.getClass();
        ToString ts = cl.getAnnotation(ToString.class);
        if (ts == null) return obj.toString();
        var wynik = new StringBuilder();
        if (ts.includeName()) wynik.append(cl.getName());
        wynik.append("[");
        boolean pierwszy = true;
        for (Field f : cl.getDeclaredFields()) {
            ts = f.getAnnotation(ToString.class);
            if (ts != null) {
                if (pierwszy) pierwszy = false; else wynik.append(",");
                f.setAccessible(true);
                if (ts.includeName()) {
                    wynik.append(f.getName());
                    wynik.append("=");
                }
                try {
                    wynik.append(ToStrings.toString(f.get(obj)));
                } catch (ReflectiveOperationException ex) {
                    ex.printStackTrace();
                }
            }
        }
        wynik.append("]");
        return wynik.toString();
    }
}
