package r10.r10_03;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;

public class RaceConditionDemo {
    public static volatile int licznik;

    public static void main(String[] args) throws InterruptedException {
        ExecutorService executor = Executors.newCachedThreadPool();
        for (int i = 1; i <= 100; i++) {
            int idZadania = i;
            Runnable zadanie = () -> {
                for (int k = 1; k <= 1000; k++)
                    licznik++;
                System.out.println(idZadania + ": " + licznik);
            };
            executor.execute(zadanie);
        }
        executor.shutdown();
        executor.awaitTermination(10, TimeUnit.MINUTES);
        System.out.println("Końcowa wartość: " + licznik);
    }
}
