package r08.r08_14;

import static java.util.stream.Collectors.counting;
import static java.util.stream.Collectors.groupingBy;
import static java.util.stream.Collectors.groupingByConcurrent;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class ParallelStreams {
    public static void main(String[] args) throws IOException {
        String contents = Files.readString(Path.of("zemsta.txt"));
        List<String> słowa = List.of(contents.split("\\PL+"));

        // Bardzo zły kod
        int[] krótkieSłowa = new int[10];
        słowa.parallelStream().forEach(
            s -> { if (s.length() < 10) krótkieSłowa[s.length()]++; });
        System.out.println(Arrays.toString(krótkieSłowa));

        // Drugie podejście - wyniki będą inne (i również błędne)
        Arrays.fill(krótkieSłowa, 0);
        słowa.parallelStream().forEach(
            s -> { if (s.length() < 10) krótkieSłowa[s.length()]++; });
        System.out.println(Arrays.toString(krótkieSłowa));

        // Lekarstwo: grupowanie i zliczanie
        Map<Integer, Long> krótkieSłowaCount =
            słowa.parallelStream()
                .filter(s -> s.length() < 10)
                .collect(
                    groupingBy(
                        String::length,
                        counting()));
               
        System.out.println(krótkieSłowaCount);
        
        // Kolejność w strumieniu przypadkowa
        Map<Integer, List<String>> wynik = słowa.parallelStream().collect(
                Collectors.groupingByConcurrent(String::length));

        System.out.println(wynik.get(14));

        wynik = słowa.parallelStream().collect(
                Collectors.groupingByConcurrent(String::length));

        System.out.println(wynik.get(14));
        
        Map<Integer, Long> wordCounts =
                słowa.parallelStream()
                    .collect(
                        groupingByConcurrent(
                            String::length,
                            counting()));
                   
        System.out.println(wordCounts);
   }
}
