package r08.r08_05;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Stream;

public class OtherTransformations {
    public static <T> void show(String title, Stream<T> stream) {
        final int SIZE = 10;
        List<T> firstElements = stream.limit(SIZE + 1).toList();
        System.out.print(title + ": ");
        if (firstElements.size() <= SIZE)
            System.out.println(firstElements);
        else {
            firstElements.remove(SIZE);
            String out = firstElements.toString();
            System.out.println(out.substring(0, out.length() - 1) + ", ...]");
        }
    }

    public static void main(String[] args) throws IOException {
        Stream<String> unikalneSłowa = Stream.of("wesoło", "wesoło", "wesoło", "delikatnie")
                .distinct();
        show("unikalneSłowa", unikalneSłowa);

        String contents = Files.readString(Path.of("zemsta.txt"));
        List<String> słowa = List.of(contents.split("\\PL+"));
        show("słowa", słowa.stream());

        Stream<String> różne =  słowa.stream().distinct();
        show("różne", różne);

        Stream<String> posortowane =  słowa.stream().sorted();
        show("posortowane", posortowane);

        Stream<String> różneSortowane =  słowa.stream().distinct().sorted();
        show("różneSortowane", różneSortowane);

        Stream<String> najdłuższeNajpierw =  słowa.stream().sorted(Comparator.comparing(String::length).reversed());
        show("najdłuższeNajpierw", najdłuższeNajpierw);
        
        Object[] potęgi = Stream.iterate(1.0, p -> p * 2)
                .peek(e -> System.out.println("Pobieranie " + e)).limit(20).toArray();
        System.out.println(Arrays.toString(potęgi));
    }
}
