package r02.r02_04;

import java.util.Date;

record Point(double x, double y) {
	// Konstruktor niestandardowy
	public Point() {
		this(0, 0);
	}

	// Metoda
	public double distanceFromOrigin() {
		return Math.hypot(x, y);
	}

	// Statyczne pole i metoda (patrz podrozdział 2.5)
	public static Point ORIGIN = new Point();

	public static double distance(Point p, Point q) {
		return Math.hypot(p.x - q.x, p.y - q.y);
	}
}

record PointInTime(double x, double y, Date when) {
}

record Range(int from, int to) {
	// Konstruktor kompaktowy
	public Range {
		if (from > to) { // Zamień elementy ograniczające.		
			int temp = from;
			from = to;
			to = temp;
		}
	}
}

public class RecordDemo {
	public static void main(String[] args) {
		var p = new Point(3, 4);
		// Metody dostępowe 
		System.out.println("Współrzędne punktu p: " + p.x() + " " + p.y());
		Point q = new Point();
		System.out.println(p + " " + q); // Dostępna jest metoda toString.

		System.out.println("Odległość od początku układu współrzędnych: " + p.distanceFromOrigin());
		// Obliczenia przy użyciu statycznego pola i metody
		System.out.println("Odległość od początku układu współrzędnych: " + Point.distance(Point.ORIGIN, p));

		// Zmienny rekord
		var pt = new PointInTime(3, 4, new Date());
		System.out.println("Przed: " + pt);
		pt.when().setTime(0);
		System.out.println("Po: " + pt);

		// "Preludium" w postaci konstruktora kompaktowego zamienia argumenty.
		var r = new Range(4, 3);
		System.out.println("r: " + r);
	}
}

