package r01.r01_07;

public class SwitchDemo {
	public static void demo(int seasonCode) {
		System.out.printf("seasonCode=%d%n", seasonCode);		

		// wyrażenie switch
		String seasonName = switch (seasonCode) { 
	    	case 0 -> "wiosna";
	    	case 1 -> "lato";
	    	case 2 -> "jesień";
	    	case 3 -> "zima";
	    	default -> { System.out.println("???"); yield ""; }
		};
		System.out.println(seasonName);
		
		// instrukcja switch
		switch (seasonCode) { // instrukcja switch
	    	case 0 -> seasonName = "wiosna";
	    	case 1 -> seasonName = "lato";
	    	case 2 -> seasonName = "jesień";
	    	case 3 -> seasonName = "zima";
	    	default -> { System.out.println("???"); seasonName = ""; }
		}
		System.out.println(seasonName);
	
		// wiele wariantów
		int numLetters = switch (seasonName) {
	    	case "wiosna", "jesień" -> 6;
	    	case "lato", "zima" -> 4;
	    	default -> throw new IllegalArgumentException();
		};
		System.out.println(numLetters);
		
		// wyrażenie switch z przejściem
		numLetters = switch (seasonName) { 
	    	case "wiosna":
	    		System.out.println("Przyszła wiosna!");
	    	case "jesień":
	    		yield 6;
	    	case "lato", "zima":
	    		yield 4;
	    	default:
	    		throw new IllegalArgumentException();
		};
		System.out.println(numLetters);
		
		//  instrukcja switch z przejściem
		switch (seasonName) { 
		    case "wiosna":
		      System.out.println("Przyszła wiosna!");
		    case "jesień":
		      numLetters = 6;
		      break;
		   case "lato", "zima":
		      numLetters = 4;
		      break;
		   default:
			  throw new IllegalArgumentException();
		}
		System.out.println(numLetters);		
	}
	
	public static void main(String[] args) {
		demo(0);
		demo(1);
		demo(2);
		demo(3);
		demo(4); // Wyrzuci wyjątek.
	}
}
