package com.horstmann.places;

/*

javac -p automods/commons-csv-1.9.0.jar \
    r15.r15_08/module-info.java \
    r15.r15_08/com/horstmann/places/CSVDemo.java -encoding UTF-8
    
java -p automods/commons-csv-1.9.0.jar:r15.r15_08 \
    -m r15.r15_08/com.horstmann.places.CSVDemo

(w systemie Windows zamiast : musi być ;)    
*/

import java.io.*;
import java.nio.charset.StandardCharsets;

import org.apache.commons.csv.*;

public class CSVDemo {
   public static void main(String[] args) throws IOException {
      var in = new FileReader("panstwa.csv", StandardCharsets.UTF_8);
      Iterable<CSVRecord> records = CSVFormat.EXCEL.withDelimiter(';').withHeader().parse(in);
      for (CSVRecord record : records) {
         String name = record.get("Nazwa");
         double area = Double.parseDouble(record.get("Powierzchnia"));
         System.out.println(name + " ma(ją) obszar " + area);
      }
   }
}
