package r12.r12_06;

import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.time.format.TextStyle;
import java.util.Locale;

public class Formatting {
    public static void main(String[] args) {
        ZonedDateTime startApollo11 = ZonedDateTime.of(1969, 7, 16, 9, 32, 0, 0, 
            ZoneId.of("America/New_York"));

        String sformatowany = DateTimeFormatter.ISO_DATE_TIME.format(startApollo11);
        // 1969-07-16T09:32:00-05:00[America/New_York]
        System.out.println(sformatowany);

        DateTimeFormatter formatter = DateTimeFormatter.ofLocalizedDateTime(FormatStyle.LONG);
        sformatowany = formatter.format(startApollo11);
        // July 16, 1969 9:32:00 AM EDT
        System.out.println(sformatowany);
        sformatowany = formatter.withLocale(Locale.FRENCH).format(startApollo11);
        // 16 juillet 1969 09:32:00 EDT
        System.out.println(sformatowany);

        formatter = DateTimeFormatter.ofPattern("E yyyy-MM-dd HH:mm");
        sformatowany = formatter.format(startApollo11);
        System.out.println(sformatowany);

        LocalDate dataUrodzeniaAlonso = LocalDate.parse("1903-06-14");
        System.out.println("dataUrodzeniaAlonso: " + dataUrodzeniaAlonso);
        startApollo11 =
            ZonedDateTime.parse("1969-07-16 03:32:00-0400",
                DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ssxx"));
        System.out.println("startApollo11: " + startApollo11);
        
        for (DayOfWeek w : DayOfWeek.values())
            System.out.print(w.getDisplayName(TextStyle.SHORT, Locale.ENGLISH) + " ");        
    }
}
