package r08.r08_07;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;

class User
{    
    public User(String id, String name) {
        this.id = id;
        this.name = name;
    }

    public String getId() {
        return id;
    }
    
    public String getName() {
        return name;
    }
    
    public String toString() {        
        return name;
    }
    
    private String id;
    private String name;
}

class Users {
    private static User[] users = {
            new User("gboole", "George Boole"),
            new User("achurch", "Alonzo Church"),
            new User("hcurry", "Haskell Curry")
    };
    
    public static Optional<User> lookup(String id) {
        return Stream.of(users).filter(u -> u.getId().equals(id)).findFirst();
    }    
    
    public static User classicLookup(String id) {
        for (User u : users) {
            if (u.getId().equals(id)) return u;
        }
        return null;
    }
}

public class OptionalDemo {
    
    public static <T> void show(String title, Stream<T> stream) {
        final int SIZE = 10;
        List<T> firstElements = stream.limit(SIZE + 1).toList();
        System.out.print(title + ": ");
        if (firstElements.size() <= SIZE)
            System.out.println(firstElements);
        else {
            firstElements.remove(SIZE);
            String out = firstElements.toString();
            System.out.println(out.substring(0, out.length() - 1) + ", ...]");
        }
    }
    
    public static void main(String[] args) throws IOException {
        String contents = Files.readString(Path.of("zemsta.txt"));
        List<String> wordList = List.of(contents.split("\\PL+"));

        Optional<String> optionalWartość = wordList.stream().filter(s -> s.contains("rejent"))
                .findFirst();
        System.out.println(optionalWartość.orElse("Żadne słowo nie") + " zawiera \"rejent\"");

        Optional<String> optionalString = Optional.empty();
        String wynik = optionalString.orElse("brak");
        System.out.println("wynik: " + wynik);
        wynik = optionalString.orElseGet(() -> System.getProperty("user.dir"));
        System.out.println("wynik: " + wynik);
        try {
            wynik = optionalString.orElseThrow(IllegalStateException::new);
            System.out.println("wynik: " + wynik);
        } catch (Throwable t) {
            t.printStackTrace();
        }
        Optional<String> wynik2 = optionalString.or(() ->
            Optional.ofNullable(System.getProperty("myapp.default")));
        System.out.println("wynik2: " + wynik2);
        
        optionalWartość = wordList.stream().filter(s -> s.contains("czerwone")).findFirst();
        optionalWartość.ifPresent(s -> System.out.println(s + " zawiera \"czerwone\""));
        
        optionalWartość = wordList.stream().filter(s -> s.contains("niebieskie")).findFirst();
        optionalWartość.ifPresentOrElse(
                s -> System.out.println(s + " zawiera \"niebieskie\""),
                () -> System.out.println("Żadne słowo nie zawiera \"niebieskie\""));
        
        var results = new HashSet<String>();
        optionalWartość.ifPresent(results::add);
        Optional<Boolean> added = optionalWartość.map(results::add);
        System.out.println("dodane: " + added);

        System.out.println(odwrotność(4.0).flatMap(OptionalDemo::pierwiastek));
        System.out.println(odwrotność(-1.0).flatMap(OptionalDemo::pierwiastek));
        System.out.println(odwrotność(0.0).flatMap(OptionalDemo::pierwiastek));
        Optional<Double> wynik3 = Optional.of(-4.0).flatMap(OptionalDemo::odwrotność)
                .flatMap(OptionalDemo::pierwiastek);
        System.out.println("wynik3: " + wynik3);
        
        Stream<String> ids = Stream.of("gboole", "jgosling");
        Stream<User> users = ids.map(Users::lookup)
            .filter(Optional::isPresent)
            .map(Optional::get);
        show("users", users);
        
        ids = Stream.of("gboole", "jgosling");
        users = ids.map(Users::lookup)
                .flatMap(Optional::stream);
        show("users", users);
        
        ids = Stream.of("gboole", "jgosling");
        users = ids.map(Users::classicLookup)
                .filter(Objects::nonNull);
        show("users", users);
        
        ids = Stream.of("gboole", "jgosling");
        users = ids.flatMap(
                id -> Stream.ofNullable(Users.classicLookup(id)));
        show("users", users);
        
        ids = Stream.of("gboole", "jgosling");
        users = ids.map(Users::classicLookup)
                .flatMap(Stream::ofNullable);
        show("users", users);
    }

    public static Optional<Double> odwrotność(Double x) {
        return x == 0 ? Optional.empty() : Optional.of(1 / x);
    }

    public static Optional<Double> pierwiastek(Double x) {
        return x < 0 ? Optional.empty() : Optional.of(Math.sqrt(x));
    }
}
