package r08.r08_06;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.List;
import java.util.Optional;

public class SimpleReductions {
    public static void main(String[] args) throws IOException {
        String contents = Files.readString(Path.of("zemsta.txt"));
        List<String> słowa = List.of(contents.split("\\PL+"));

        Optional<String> największe = słowa.stream().max(String::compareToIgnoreCase);
        System.out.println("największe: " + największe.orElse(""));

        boolean słowoZaczynająceSięOdQ = słowa.stream().anyMatch(s -> s.startsWith("Q"));
        System.out.println("słowoZaczynająceSięOdQ: " + słowoZaczynająceSięOdQ);

        Optional<String> zaczynaSięOdQ = słowa.stream().parallel().filter(s -> s.startsWith("Q")).findAny();
        System.out.println("zaczynaSięOdQ: " + zaczynaSięOdQ.orElse("(None)"));
            // Uruchom program jeszcze raz, by sprawdzić, czy znajdzie inne słowo.
    }
}
