/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.yasson.internal;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Set;
import org.eclipse.yasson.internal.AnnotationIntrospector;
import org.eclipse.yasson.internal.model.JsonbCreator;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
class ClassMultiReleaseExtension {
    private static final Set<String> NOT_VALID_ACCESSOR_METHODS = Set.of("equals", "hashCode", "toString");

    private ClassMultiReleaseExtension() {
        throw new IllegalStateException("This class cannot be instantiated");
    }

    static boolean shouldTransformToPropertyName(Method method) {
        return !method.getDeclaringClass().isRecord();
    }

    static boolean isGetAccessorMethod(Method method) {
        if (method.getDeclaringClass().isRecord()) {
            return !NOT_VALID_ACCESSOR_METHODS.contains(method.getName());
        }
        return false;
    }

    static JsonbCreator findJsonbCreator(Class<?> clazz, Constructor<?>[] declaredConstructors, AnnotationIntrospector introspector) {
        if (clazz.isRecord()) {
            return introspector.createJsonbCreator(declaredConstructors[0], null, clazz);
        }
        return null;
    }
}

