package numberFormat;

import java.text.*;
import java.util.*;
import util.*;

/**
 * Program demonstrujący formatowanie liczb dla różnych lokalizatorów.
 * @version 2.0 2021-09-22
 * @author Cay Horstmann
 */
public class NumberFormatTest2
{
   public static void main(String[] args)
   {
      Scanner in = new Scanner(System.in);
      var locales = (Locale[]) NumberFormat.getAvailableLocales().clone();
      Arrays.sort(locales, Comparator.comparing(Locale::getDisplayName));
      Locale locale = Choices.choose(in, locales, Locale::getDisplayName);
      
      var formatters = new LinkedHashMap<NumberFormat, String>();
      formatters.put(NumberFormat.getNumberInstance(locale), "Liczba");
      formatters.put(NumberFormat.getCompactNumberInstance(
         locale, NumberFormat.Style.SHORT), "Zwarta krótka");
      formatters.put(NumberFormat.getCompactNumberInstance(
         locale, NumberFormat.Style.LONG), "Zwarta długa");
      formatters.put(NumberFormat.getPercentInstance(locale), "Procent");
      formatters.put(NumberFormat.getCurrencyInstance(locale), "Waluta");
      NumberFormat formatter = Choices.choose(in, formatters);
      
      String operation = Choices.choose(in, "Formatuj", "Analizuj");
      if (operation.equals("Formatuj"))
      {
         System.out.print("Wpisz liczbę zmiennoprzecinkową do sformatowania: ");
         double number = in.nextDouble();
         System.out.println(formatter.format(number));
      }
      else
      {
         System.out.print("Wpisz liczbę zmiennoprzecinkową do przeanalizowania: ");
         String text = in.next();
         try 
         {
            System.out.println(formatter.parse(text));
         } 
         catch (ParseException e) 
         {
            System.out.println("ParseException " + e.getMessage());
         }
      }
   }
}
