package treeModel;

import java.awt.*;
import javax.swing.*;

/**
 * Ramka zawierająca drzewo
 */
public class ObjectInspectorFrame extends JFrame
{
   private JTree tree;
   private static final int DEFAULT_WIDTH = 400;
   private static final int DEFAULT_HEIGHT = 300;

   public ObjectInspectorFrame()
   {
      setSize(DEFAULT_WIDTH, DEFAULT_HEIGHT);

      // Jako pierwszy inspekcji poddany jest obiekt ramki

      var v = new Variable(getClass(), "this", this);
      var model = new ObjectTreeModel();
      model.setRoot(v);

      // Tworzy i prezentuje drzewo

      tree = new JTree(model);
      add(new JScrollPane(tree), BorderLayout.CENTER);
   }
}
