package collecting;

import java.io.*;
import java.nio.file.*;
import java.util.*;
import java.util.stream.*;

/**
 * @version 1.02 2019-08-28
 * @author Cay Horstmann
 */
public class CollectingResults
{
   public static Stream<String> noVowels() throws IOException
   {
      String contents = Files.readString(Path.of("../gutenberg/alice30.txt"));
      List<String> wordList = List.of(contents.split("\\PL+"));
      Stream<String> words = wordList.stream();
      return words.map(s -> s.replaceAll("[aeiouAEIOU]", ""));
   }

   public static <T> void show(String label, Set<T> set)
   {
      System.out.print(label + ": " + set.getClass().getName());
      System.out.println("["
         + set.stream().limit(10).map(Object::toString).collect(Collectors.joining(", ")) 
         + "]");
   }

   public static void main(String[] args) throws IOException
   {
      Iterator<Integer> iter = Stream.iterate(0, n -> n + 1).limit(10).iterator();
      while (iter.hasNext())
         System.out.println(iter.next());

      Object[] numbers = Stream.iterate(0, n -> n + 1).limit(10).toArray();
      System.out.println("Object array:" + numbers); 
         // To jest tablica typu Object[]

      try
      {
         var number = (Integer) numbers[0]; // OK
         System.out.println("number: " + number);
         System.out.println("Poniższa instrukcja zgłasza wyjątek:");
         var numbers2 = (Integer[]) numbers; // Zgłasza wyjątek 
      }
      catch (ClassCastException e)
      {
         System.out.println(e);
      }

      Integer[] numbers3 = Stream.iterate(0, n -> n + 1)
         .limit(10)
         .toArray(Integer[]::new);
      System.out.println("Tablica liczb całkowitych: " + numbers3); 
         // Należy zwrócić uwagę, że jest to tablica typu Integer[]

      Set<String> noVowelSet = noVowels().collect(Collectors.toSet());
      show("noVowelSet", noVowelSet);

      TreeSet<String> noVowelTreeSet = noVowels().collect(
         Collectors.toCollection(TreeSet::new));
      show("noVowelTreeSet", noVowelTreeSet);

      String result = noVowels().limit(10).collect(Collectors.joining());
      System.out.println("Konkatenacja: " + result);
      result = noVowels().limit(10)
         .collect(Collectors.joining(", "));
      System.out.println("Konkatenacja z użyciem przecinków: " + result);

      IntSummaryStatistics summary = noVowels().collect(
         Collectors.summarizingInt(String::length));
      double averageWordLength = summary.getAverage();
      double maxWordLength = summary.getMax();
      System.out.println("Średnia długość słowa: " + averageWordLength);
      System.out.println("Maksymalna długość słowa: " + maxWordLength);
      System.out.println("forEach:");
      noVowels().limit(10).forEach(System.out::println);
   }
}
