package classLoader;

import java.io.*;
import java.lang.reflect.*;
import java.nio.file.*;
import java.util.*;

/**
 * Program demonstrujący wykorzystanie własnej procedury ładującej
 * zaszyfrowane pliki klas
 * @version 1.3 2023-11-12
 * @author Cay Horstmann
 */
public class ClassLoaderTest
{
   public static void main(String[] args) throws ReflectiveOperationException
   {
      Scanner in = new Scanner(System.in);
      System.out.print("Nazwa klasy: ");
      String className = in.nextLine();
      System.out.print("Klucz deszyfrujący: ");
      int decryptionKey = in.nextInt();
      var loader = new CryptoClassLoader(decryptionKey);
      Class<?> c = loader.loadClass(className);
      Method m = c.getMethod("main", String[].class);
      m.invoke(null, (Object) new String[] {});
   }
}

/**
 * Klasa procedury ładującej zaszyfrowane pliki klas
 */
class CryptoClassLoader extends ClassLoader
{
   private int key;

   /**
    * Tworzy obiekt klasy CryptoClassLoader
    * @param k klucz szyfrowania
    */
   public CryptoClassLoader(int k)
   {
      key = k;
   }

   protected Class<?> findClass(String name) throws ClassNotFoundException
   {
      try
      {
         byte[] classBytes = loadClassBytes(name);
         Class<?> cl = defineClass(name, classBytes, 0, classBytes.length);
         if (cl == null) throw new ClassNotFoundException(name);
         return cl;
      }
      catch (IOException e)
      {
         throw new ClassNotFoundException(name);
      }
   }

   /**
    * Wczytuje i odszyfrowuje kod klasy
    * @param name nazwa klasy
    * @return tablica zawierająca kod klasy
    */
   private byte[] loadClassBytes(String name) throws IOException
   {
      String cname = name.replace(".", "/") + ".caesar";
      byte[] bytes = Files.readAllBytes(Path.of(cname));
      for (int i = 0; i < bytes.length; i++)
         bytes[i] = (byte) (bytes[i] - key);
      return bytes;
   }
}
