package serial;

public class Manager extends Employee
{
   private Employee secretary;

   /**
    * Tworzymy obiekt Manager bez sekretarza
    * 
    * @param n     imię pracownika
    * @param s     wynagrodzenie
    * @param year  rok daty zatrudnienia
    * @param month miesiąc daty zatrudnienia
    * @param day   dzień daty zatrudnienia
    */
   public Manager(String n, double s, int year, int month, int day)
   {
      super(n, s, year, month, day);
      secretary = null;
   }

   /**
    * Przypisanie sekretarza do menedżera.
    * 
    * @param s sekretarz
    */
   public void setSecretary(Employee s)
   {
      secretary = s;
   }

   public String toString()
   {
      return super.toString() + "[secretary=" + secretary + "]";
   }
}
