package socket;

import java.io.*;
import java.net.*;
import java.nio.charset.*;
import java.util.*;

/**
 * Program łączący się z zegarem atomowym w Boulder, w stanie Colorado, 
 * i wyświetlający uzyskany czas.
 * @version 1.22 2018-03-17
 * @author Cay Horstmann
 */
public class SocketTest
{
   public static void main(String[] args) throws IOException
   {
      try (var s = new Socket("time-a.nist.gov", 13);
            var in = new Scanner(s.getInputStream(), StandardCharsets.UTF_8))
      {
         while (in.hasNextLine())
         {
            String line = in.nextLine();
            System.out.println(line);
         }
      }
   }
}
