package tree;

import javax.swing.*;
import javax.swing.tree.*;

/**
 * Ta ramka zawiera proste drzewo wyświetlające ręcznie utworzony model drzewa.
 */
public class SimpleTreeFrame extends JFrame
{
   private static final int DEFAULT_WIDTH = 300;
   private static final int DEFAULT_HEIGHT = 200;

   public SimpleTreeFrame()
   {
      setSize(DEFAULT_WIDTH, DEFAULT_HEIGHT);

      // Przygotowanie modelu danych drzewa

      var root = new DefaultMutableTreeNode("Świat");
      var country = new DefaultMutableTreeNode("USA");
      root.add(country);
      var state = new DefaultMutableTreeNode("Kalifornia");
      country.add(state);
      var city = new DefaultMutableTreeNode("San Jose");
      state.add(city);
      city = new DefaultMutableTreeNode("Cupertino");
      state.add(city);
      state = new DefaultMutableTreeNode("Michigan");
      country.add(state);
      city = new DefaultMutableTreeNode("Ann Arbor");
      state.add(city);
      country = new DefaultMutableTreeNode("Niemcy");
      root.add(country);
      state = new DefaultMutableTreeNode("Schleswig-Holstein");
      country.add(state);
      city = new DefaultMutableTreeNode("Kilonia");
      state.add(city);

      // Tworzy drzewo i umieszcza je w przewijalnym panelu

      var tree = new JTree(root);
      add(new JScrollPane(tree));
   }

}


