package tableModel;

import java.awt.*;

import javax.swing.*;
import javax.swing.table.*;

/**
 * Program tworzący tabelę w oparciu o własny model.
 * @version 1.04 2018-05-01
 * @author Cay Horstmann
 */
public class InvestmentTable
{
   public static void main(String[] args)
   {
      EventQueue.invokeLater(() ->
         {
            var frame = new InvestmentTableFrame();
            frame.setTitle("InvestmentTable");               
            frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
            frame.setVisible(true);
         });
   }
}

/**
 * Ramka zawierająca tabelę inwestycji.
 */
class InvestmentTableFrame extends JFrame
{
   public InvestmentTableFrame()
   {
      var model = new InvestmentTableModel(30, 5, 10);
      var table = new JTable(model);
      add(new JScrollPane(table));
      pack();
   }

}

/**
 * Model tabeli wyliczający wartości komórek na żądanie.
 * Tabela pokazuje przyrost inwestycji w kolejnych latach
 * w różnych scenariuszach.
 */
class InvestmentTableModel extends AbstractTableModel
{
   private static double INITIAL_BALANCE = 100000.0;
   
   private int years;
   private int minRate;
   private int maxRate;

   /**
    * Tworzy model tabeli inwestycji.
    * @param y liczba lat
    * @param r1 najniższy procent do uwzględnienia
    * @param r2 najwyższy procent do uwzględnienia    
    */
   public InvestmentTableModel(int y, int r1, int r2)
   {
      years = y;
      minRate = r1;
      maxRate = r2;
   }

   public int getRowCount()
   {
      return years;
   }

   public int getColumnCount()
   {
      return maxRate - minRate + 1;
   }

   public Object getValueAt(int r, int c)
   {
      double rate = (c + minRate) / 100.0;
      int nperiods = r;
      double futureBalance = INITIAL_BALANCE * Math.pow(1 + rate, nperiods);
      return String.format("%.2f", futureBalance);
   }

   public String getColumnName(int c)
   {
      return (c + minRate) + "%";
   }
}
