/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.yasson.internal.model;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.util.Optional;
import java.util.function.Function;
import javax.json.bind.config.PropertyVisibilityStrategy;
import org.eclipse.yasson.internal.JsonbContext;
import org.eclipse.yasson.internal.model.Property;
import org.eclipse.yasson.internal.model.ReflectionPropagation;

public abstract class PropertyValuePropagation {
    private final Field field;
    private final Method getter;
    private final Method setter;
    protected boolean writable;
    protected boolean readable;

    protected PropertyValuePropagation(Property property, JsonbContext ctx) {
        this.field = property.getField();
        this.getter = property.getGetter();
        this.setter = property.getSetter();
        this.initReadable(this.field, this.getter, ctx);
        this.initWritable(this.field, this.setter, ctx);
    }

    public static PropertyValuePropagation createInstance(Property property, JsonbContext ctx) {
        return new ReflectionPropagation(property, ctx);
    }

    private void initReadable(Field field, Method getter, JsonbContext ctx) {
        boolean fieldReadable;
        boolean bl = fieldReadable = field == null || (field.getModifiers() & 0x88) == 0;
        if (!fieldReadable) {
            this.readable = false;
            return;
        }
        if (getter != null && this.isMethodVisible(field, getter, ctx)) {
            this.acceptMethod(getter, OperationMode.GET);
            this.readable = true;
        } else if (this.isFieldVisible(field, getter, ctx)) {
            this.acceptField(field, OperationMode.GET);
            this.readable = true;
        }
    }

    private void initWritable(Field field, Method setter, JsonbContext ctx) {
        boolean fieldWritable;
        boolean bl = fieldWritable = field == null || (field.getModifiers() & 0x98) == 0;
        if (!fieldWritable) {
            this.writable = false;
            return;
        }
        if (setter != null && this.isMethodVisible(field, setter, ctx) && !setter.getDeclaringClass().isAnonymousClass()) {
            this.acceptMethod(setter, OperationMode.SET);
            this.writable = true;
        } else if (this.isFieldVisible(field, setter, ctx) && !field.getDeclaringClass().isAnonymousClass()) {
            this.acceptField(field, OperationMode.SET);
            this.writable = true;
        }
    }

    private boolean isFieldVisible(Field field, Method method, JsonbContext ctx) {
        if (field == null) {
            return false;
        }
        Boolean accessible = this.isVisible(strategy -> strategy.isVisible(field), field.getDeclaringClass(), field, method, ctx);
        if (accessible.booleanValue() && (!Modifier.isPublic(field.getModifiers()) || field.getDeclaringClass().isAnonymousClass())) {
            this.overrideAccessible(field);
        }
        return accessible;
    }

    private boolean isMethodVisible(Field field, Method method, JsonbContext ctx) {
        if (method == null || Modifier.isStatic(method.getModifiers())) {
            return false;
        }
        Boolean accessible = this.isVisible(strategy -> strategy.isVisible(method), method.getDeclaringClass(), field, method, ctx);
        if (accessible.booleanValue() && (!Modifier.isPublic(method.getModifiers()) || method.getDeclaringClass().isAnonymousClass())) {
            this.overrideAccessible(method);
        }
        return accessible;
    }

    private void overrideAccessible(AccessibleObject accessibleObject) {
        AccessController.doPrivileged(() -> {
            accessibleObject.setAccessible(true);
            return null;
        });
    }

    private Boolean isVisible(Function<PropertyVisibilityStrategy, Boolean> visibilityCheckFunction, Class<?> declaringClass, Field field, Method method, JsonbContext ctx) {
        Optional<PropertyVisibilityStrategy> classLevelStrategy = ctx.getAnnotationIntrospector().getPropertyVisibilityStrategy(declaringClass);
        Optional<PropertyVisibilityStrategy> strategy = Optional.ofNullable(classLevelStrategy.orElseGet(() -> ctx.getConfigProperties().getPropertyVisibilityStrategy()));
        PropertyVisibilityStrategy str = strategy.orElse(new DefaultVisibilityStrategy(field, method));
        return visibilityCheckFunction.apply(str);
    }

    protected abstract void acceptMethod(Method var1, OperationMode var2);

    protected abstract void acceptField(Field var1, OperationMode var2);

    abstract void setValue(Object var1, Object var2);

    abstract Object getValue(Object var1);

    public boolean isWritable() {
        return this.writable;
    }

    public boolean isReadable() {
        return this.readable;
    }

    public Field getField() {
        return this.field;
    }

    public Method getGetter() {
        return this.getter;
    }

    public Method getSetter() {
        return this.setter;
    }

    private static final class DefaultVisibilityStrategy
    implements PropertyVisibilityStrategy {
        private final Field field;
        private final Method method;

        public DefaultVisibilityStrategy(Field field, Method method) {
            this.field = field;
            this.method = method;
        }

        public boolean isVisible(Field field) {
            if (this.method != null && !this.isVisible(this.method)) {
                return false;
            }
            return Modifier.isPublic(field.getModifiers());
        }

        public boolean isVisible(Method method) {
            return Modifier.isPublic(method.getModifiers());
        }
    }

    public static enum OperationMode {
        GET,
        SET;

    }
}

