/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.yasson.internal.serializer;

import java.lang.reflect.Type;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;
import javax.json.bind.serializer.JsonbSerializer;
import javax.json.bind.serializer.SerializationContext;
import javax.json.stream.JsonGenerator;
import org.eclipse.yasson.internal.Marshaller;
import org.eclipse.yasson.internal.ReflectionUtils;
import org.eclipse.yasson.internal.model.ClassModel;
import org.eclipse.yasson.internal.model.JsonBindingModel;
import org.eclipse.yasson.internal.model.PropertyModel;
import org.eclipse.yasson.internal.serializer.AbstractContainerSerializer;
import org.eclipse.yasson.internal.serializer.CurrentItem;
import org.eclipse.yasson.internal.serializer.SerializerBuilder;

public class ObjectSerializer<T>
extends AbstractContainerSerializer<T> {
    public ObjectSerializer(SerializerBuilder builder) {
        super(builder);
    }

    public ObjectSerializer(CurrentItem<?> wrapper, Type runtimeType, ClassModel classModel, JsonBindingModel wrapperModel) {
        super(wrapper, runtimeType, classModel, wrapperModel);
    }

    @Override
    protected void serializeInternal(T object, JsonGenerator generator, SerializationContext ctx) {
        PropertyModel[] allProperties;
        for (PropertyModel model : allProperties = ((Marshaller)ctx).getMappingContext().getOrCreateClassModel(object.getClass()).getSortedProperties()) {
            this.marshallProperty(object, generator, ctx, model);
        }
    }

    @Override
    protected void writeStart(JsonGenerator generator) {
        generator.writeStartObject();
    }

    @Override
    protected void writeStart(String key, JsonGenerator generator) {
        generator.writeStartObject(key);
    }

    private void marshallProperty(T object, JsonGenerator generator, SerializationContext ctx, PropertyModel propertyModel) {
        Marshaller marshaller = (Marshaller)ctx;
        if (propertyModel.isReadable()) {
            Object propertyValue = propertyModel.getValue(object);
            if (propertyValue == null || this.isEmptyOptional(propertyValue)) {
                if (propertyModel.getCustomization().isNillable()) {
                    generator.writeNull(propertyModel.getWriteName());
                }
                return;
            }
            generator.writeKey(propertyModel.getWriteName());
            JsonbSerializer<?> propertyCachedSerializer = propertyModel.getPropertySerializer();
            if (propertyCachedSerializer != null) {
                this.serializerCaptor(propertyCachedSerializer, propertyValue, generator, ctx);
                return;
            }
            Optional<Type> runtimeTypeOptional = ReflectionUtils.resolveOptionalType(this, propertyModel.getType());
            Type genericType = runtimeTypeOptional.orElse(null);
            JsonbSerializer<?> serializer = ((SerializerBuilder)((SerializerBuilder)((SerializerBuilder)new SerializerBuilder(marshaller.getJsonbContext()).withWrapper(this)).withObjectClass(propertyValue.getClass()).withModel(propertyModel)).withType(genericType)).build();
            this.serializerCaptor(serializer, propertyValue, generator, ctx);
        }
    }

    private boolean isEmptyOptional(Object object) {
        if (object instanceof Optional) {
            return !((Optional)object).isPresent();
        }
        if (object instanceof OptionalInt) {
            return !((OptionalInt)object).isPresent();
        }
        if (object instanceof OptionalLong) {
            return !((OptionalLong)object).isPresent();
        }
        if (object instanceof OptionalDouble) {
            return !((OptionalDouble)object).isPresent();
        }
        return false;
    }
}

