import java.io.*;
import java.util.Hashtable;
import java.util.Enumeration;

import org.w3c.dom.*;
import org.xml.sax.*;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.parsers.SAXParser;

public class XMLTest {

  public static void main (String argv []) throws IOException {

    // Check for the appropriate usage
    if ( argv.length != 1 ) {
      System.err.println ("USAGE: java XMLTest filename");
      System.exit(1);
    }

    try {

      // Get the path to the file
      String xmlResource = "file:" +
        new File(argv[0]).getAbsolutePath();

      Parser parser;
      // Get an instance of the SAXParserFactory
      SAXParserFactory spf = SAXParserFactory.newInstance();
      // Get a SAXParser instance from the factory
      SAXParser sp = spf.newSAXParser();

      // Create an instance of our HandlerBase
      SAXHandler handler = new SAXHandler();

      // Set the Document handler to call our SAXHandler when
      // SAX event occurs while parsing our XMLResource
      sp.parse(xmlResource, handler);
      // After the resource has been parsed get the resulting table
      Hashtable cfgTable = handler.getTable();

      // Print the config settings that we are interested in.
      System.out.println("ID == " +
        (String)cfgTable.get(new String("ID")));
      System.out.println("DESCRIPTION == " +
        (String)cfgTable.get(new String("DESCRIPTION")));
      System.out.println("PRICE == " +
        (String)cfgTable.get(new String("PRICE")));
      System.out.println("QUANTITY == " +
        (String)cfgTable.get(new String("QUANTITY")));
    }
    catch (Exception e) {

      e.printStackTrace();
    }
    System.exit(0);
  }
}
