import java.io.*;

import java.util.Hashtable;

import org.xml.sax.*;

public class SAXHandler extends HandlerBase {

  private Hashtable table = new Hashtable();
  private String currentElement = null;
  private String currentValue = null;

  // Simple Accessor for the Hashtable of parsed values
  public void setTable(Hashtable table) {

    this.table = table;
  }

  // Simple Accessor for the Hashtable of parsed values
  public Hashtable getTable() {

    return table;
  }

  // Called when a new element is encountered
  public void startElement(String tag, AttributeList attrs)
    throws SAXException {

    // hold onto the new element tag, that will be placed in
    // our Hashtable when matching character data is encountered.
	  currentElement = tag;
  }

  // Called when character data is found inside an element
  public void characters(char[] ch, int start, int length)
    throws SAXException {

    // create a String containing the characters
    // found in the element
    currentValue = new String(ch, start, length);
  }

  // Called when the end of element is encountered
  public void endElement(String name) throws SAXException {

    // Make sure we have a matching closing element
	  if ( currentElement.equals(name) ) {

      // Put the element/value pair into the Hashtable
      table.put(currentElement, currentValue);
    }
  }
}

