<html>
  <body>
<%@ page errorPage="errorpage.jsp" %>
<%@ page import="java.util.*" %>
<%@ page import="java.sql.*" %>

<!-- Instantiate the ConnectionPool bean with an id of "pool" -->
<jsp:useBean id="pool" 
  scope="application"
  class="com.purejsp.connectionpool.ConnectionPool" />

<%

  Connection con = null;
  
  try {

    // The pool is not initialized
    if ( pool.getDriver() == null ) {
    
      // initialize the pool
      pool.setDriver("sun.jdbc.odbc.JdbcOdbcDriver");
      pool.setURL("jdbc:odbc:Movie Catalog");
      pool.setSize(5);
      pool.initializePool();
    }
   
    // Get a connection from the ConnectionPool
    con = pool.getConnection();

    // Create the statement
    Statement statement = con.createStatement();

    // Use the created statement to SELECT the DATA
    // FROM the Titles Table.
    ResultSet rs = statement.executeQuery("SELECT * " +
      "FROM Titles");

    // Iterate over the ResultSet
    %>
    <!-- Add an HTML table to format the results -->
    <center>
    <table border="1" cellspacing="0" cellpadding="2"width="500">
      <tr>
        <th>Title</th><th>Rating</th><th>Price</th><th>Quantity</th>
    <%

    while ( rs.next() ) {

      // get the title_name, which is a String
      out.println("<tr>\n<td>" +
        rs.getString("title_name") + "</td>");

      // get the rating
      out.println("<td align=\"center\">" +
        rs.getString("rating") + "</td>");

      // get the price
      out.println("<td align=\"center\">" +
        rs.getString("price") + "</td>");

      // get the quantity
      out.println("<td align=\"center\">" +
        rs.getString("quantity") + "</td>\n</tr>");
    }
    // Close the ResultSet
    rs.close();
    out.println("</table></center>");
  }
  catch (IOException ioe) {

    out.println(ioe.getMessage());
  }
  catch (SQLException sqle) {

    out.println(sqle.getMessage());
  }
  catch (ClassNotFoundException cnfe) {

    out.println(cnfe.getMessage());
  }
  catch (Exception e) {

    out.println(e.getMessage());
  }
  finally {

    try {

      if ( con != null ) {

        // release the connection no matter what
        pool.releaseConnection(con);
      }
    }
    catch (Exception e) {

      out.println(e.getMessage());
    }
  }
%>
  </body>
</html>
