package com.oreilly.servlet;

import java.io.*;
import java.util.*;
import javax.servlet.*;


public class ParameterParser {

  private ServletRequest req;
  private String encoding;

  public ParameterParser(ServletRequest req) {
    this.req = req;
  }

  public void setCharacterEncoding(String encoding) 
                 throws UnsupportedEncodingException {
    // Sprawdzenie prawidowoci kodowania    
    new String("".getBytes("8859_1"), encoding);
    // Jeeli prawidowe to ustawiamy
    this.encoding = encoding;
  }

  public String getStringParameter(String name)
      throws ParameterNotFoundException {
    String[] values = req.getParameterValues(name);
    if (values == null) {
      throw new ParameterNotFoundException(name + " nie znaleziono");
    }
    else if (values[0].length() == 0) {
      throw new ParameterNotFoundException(name + " by pusty");
    }
    else {
      if (encoding == null) {
        return values[0];
      }
      else {
        try {
          return new String(values[0].getBytes("8859_1"), encoding);
        }
        catch (UnsupportedEncodingException e) {
          return values[0];  // nie powinno si nigdy zdarzyc
        }
      }
    }
  }

  public String getStringParameter(String name, String def) {
    try { return getStringParameter(name); }
    catch (Exception e) { return def; }
  }

  public boolean getBooleanParameter(String name)
      throws ParameterNotFoundException, NumberFormatException {
    String value = getStringParameter(name).toLowerCase();
    if ((value.equalsIgnoreCase("true")) ||
        (value.equalsIgnoreCase("on")) ||
        (value.equalsIgnoreCase("yes"))) {
        return true;
    }
    else if ((value.equalsIgnoreCase("false")) ||
             (value.equalsIgnoreCase("off")) ||
             (value.equalsIgnoreCase("no"))) {
        return false;
    }
    else {
      throw new NumberFormatException("Parametr " + name + " warto " + value + 
                                      " nie jest typu boolean");
    }
  }

  public boolean getBooleanParameter(String name, boolean def) {
    try { return getBooleanParameter(name); }
    catch (Exception e) { return def; }
  }


  public byte getByteParameter(String name)
      throws ParameterNotFoundException, NumberFormatException {
    return Byte.parseByte(getStringParameter(name));
  }

  public byte getByteParameter(String name, byte def) {
    try { return getByteParameter(name); }
    catch (Exception e) { return def; }
  }

  public char getCharParameter(String name)
      throws ParameterNotFoundException {
    String param = getStringParameter(name);
    if (param.length() == 0)
      throw new ParameterNotFoundException(name + " jest pustym acuchem");
    else
      return (param.charAt(0));
  }

  public char getCharParameter(String name, char def) {
    try { return getCharParameter(name); }
    catch (Exception e) { return def; }
  }

  public double getDoubleParameter(String name)
      throws ParameterNotFoundException, NumberFormatException {
    return new Double(getStringParameter(name)).doubleValue();
  }

  public double getDoubleParameter(String name, double def) {
    try { return getDoubleParameter(name); }
    catch (Exception e) { return def; }
  }

  public float getFloatParameter(String name)
      throws ParameterNotFoundException, NumberFormatException {
    return new Float(getStringParameter(name)).floatValue();
  }

  public float getFloatParameter(String name, float def) {
    try { return getFloatParameter(name); }
    catch (Exception e) { return def; }
  }

  public int getIntParameter(String name)
      throws ParameterNotFoundException, NumberFormatException {
    return Integer.parseInt(getStringParameter(name));
  }


  public int getIntParameter(String name, int def) {
    try { return getIntParameter(name); }
    catch (Exception e) { return def; }
  }

  public long getLongParameter(String name)
      throws ParameterNotFoundException, NumberFormatException {
    return Long.parseLong(getStringParameter(name));
  }

  public long getLongParameter(String name, long def) {
    try { return getLongParameter(name); }
    catch (Exception e) { return def; }
  }

  public short getShortParameter(String name)
      throws ParameterNotFoundException, NumberFormatException {
    return Short.parseShort(getStringParameter(name));
  }

  public short getShortParameter(String name, short def) {
    try { return getShortParameter(name); }
    catch (Exception e) { return def; }
  }

  public String[] getMissingParameters(String[] required) {
    Vector missing = new Vector();
    for (int i = 0; i < required.length; i++) {
      String val = getStringParameter(required[i], null);
      if (val == null) {
        missing.addElement(required[i]);
      }
    }
    if (missing.size() == 0) {
      return null;
    }
    else {
      String[] ret = new String[missing.size()];
      missing.copyInto(ret);
      return ret;
    }
  }
}
