import java.io.*;
import java.sql.*;
import java.util.*;
import javax.servlet.*;
import javax.servlet.http.*;

import com.oreilly.servlet.CacheHttpServlet;

public class Guestbook extends CacheHttpServlet {
   static final String SELECT_ALL =
      "SELECT name, email, cmt, id FROM guestlist ORDER BY id DESC"; 

   static final String INSERT =
      "INSERT INTO guestlist (id, name, email, cmt) " +
      "VALUES (?,?,?,?)";
   private long lastModified = 0; //
   private ConnectionPool pool;

 // pobierz wskanik do puli pocze
 public void init() throws ServletException {
      try {
         ServletContext context = getServletContext();
         synchronized (context) {
            // Pula moe ju istnieje, jako atrybut kontekstu
            pool = (ConnectionPool) context.getAttribute("pool");
            if (pool == null) {
            // Skonstruuj pul pocze uywajc parametrw kontekstu inicjalizujcego
            // connection.driver, connection.url, user, password, itd.
            pool= new ConnectionPool( new ContextProperties(context), 3);
            context.setAttribute("pool", pool);
         }
       }
      }

      catch(Exception e) {
         throw new UnavailableException(
         "Nie mona pobra puli pocze z kontekstu: " + e.getMessage());
      }
   }

// Wywietl istniejce w bazie danych pozycje, popro o wpisanie nowej
public void doGet (HttpServletRequest req, HttpServletResponse res)
           throws ServletException, IOException {
   res.setContentType("text/html; charset=ISO-8859-2");
   PrintWriter out = res.getWriter();

   printHeader(out);
   printForm(out);
   printMessages(out);
   printFooter(out);
}
   

// Dodaj now pozycj i wylij j do doGet
       public void doPost(HttpServletRequest req, HttpServletResponse res)
                throws ServletException, IOException {
         handleForm (req, res);
         doGet(req, res);
      }

private void printHeader (PrintWriter out) {
   out.println("<HTML><HEAD><TITLE>Guestbook</TITLE></HEAD>");
   out.println("<BODY>");
}

private void printForm (PrintWriter out) {
   out.println("<FORM METHOD=POST>"); // wysya do siebie
         out.println("<B>Przelij swoje informacje:</B><BR>");
   out.println("Twoje imi i nazwisko: <INPUT TYPE=TEXT NAME=name><BR>");
   out.println("Twj adres e-mail: <INPUT TYPE=TEXT NAME=email><BR>");
   out.println("Komentarz: <INPUT TYPE=TEXT SIZE=50 NAME=comment><BR>");
   out.println("<INPUT TYPE=SUBMIT VALUE=\"Przelij informacje\"><BR>");
   out.println("</FORM>");
   out.println("<HR>");
     }
      // przeczytaj i wywietl wiadomoci z bazy danych 
private void printMessages (PrintWriter out) throws ServletException {
   String name, email, comment;

   Connection con= null;
   Statement stmt = null; 
   ResultSet rs = null;

   try {
      con = pool.getConnection();
   stmt = con.createStatement();
   rs = stmt.executeQuery (SELECT_ALL);

      while (rs.next()) {
      name = rs.getString(1);
      if (rs.wasNull()||name.length()==0) name = "Nieznany uytkownik";
      email = rs.getString(2);
      if (rs.wasNull()||email.length()==0) name = "Nieznany adres e-mail";
      comment = rs.getString(3);
       if (rs.wasNull()||comment.length()==0) name = "Bez komentarzy";
      out.println("<DL>");
      out.println("<DT><B>" + name + "</B> (" + email + ") mwi");
      out.println("<DD><PRE>" + comment + "</PRE>");
      out.println("</DL>");
      }
   }
   catch (SQLException e) {
         throw new ServletException(e);
   }
   finally {
      try {
          if (stmt != null) stmt.close();
   }
      catch (SQLException ignored) {}
      pool.returnConnection(con);
   }
}

private void printFooter (PrintWriter out) {
   out.println("</BODY>");
}

// zachowaj nowy komentarz w bazie danych
private void handleForm (HttpServletRequest req,
                         HttpServletResponse res) throws ServletException {
   String name = req.getParameter("name");
   String email = req.getParameter("email");
    String comment = req.getParameter("comment");

   Connection con = null;
PreparedStatement pstmt = null;
   try {
      con = pool.getConnection();
      // Uyj przygotowanej instrukcji aby automatycznie unika znakw specjalnych
      pstmt = con.prepareStatement(INSERT);
long time = System.currentTimeMillis();
      pstmt.setString(1, Long.toString(time));
      pstmt.setString(2, name);
      pstmt.setString(3, email);
      pstmt.setString(4, comment);
      pstmt.executeUpdate();
   }
   catch (SQLException e) {
      throw new ServletException(e);
   }
   finally {
      try {
            if (pstmt != null) pstmt.close();
      }
       catch (SQLException ignored) {}
       pool.returnConnection(con);
   }
   //zauwa,e posiadamy nowo zmodyfikowany czas
   lastModified = System.currentTimeMillis();
}

public long getLastModified(HttpServletRequest req) {
   return lastModified; // obuguje CacheHttpServlet
  }
}
