import java.io.*;
import javax.servlet.*;
import javax.servlet.http.*;

public class ErrorDisplay extends HttpServlet {

  public void doGet(HttpServletRequest req, HttpServletResponse res)
                               throws ServletException, IOException {
    res.setContentType("text/html");
    PrintWriter out = res.getWriter();

    String code = null, message = null, type = null;
    Object codeObj, messageObj, typeObj;

    // Odczytanie trzech moliwych atrybutw bdw. Niektre mog mie warto null
    codeObj = req.getAttribute("javax.servlet.error.status_code");
    messageObj = req.getAttribute("javax.servlet.error.message");
    typeObj = req.getAttribute("javax.servlet.error.exception_type");

    // Konwersja atrybutw na wartoci acuchowe
    // Dlatego, e niektre stare typy serwerw zwracaj String
    // a nowe Integer, String i Class

    if (codeObj != null) code = codeObj.toString();
    if (messageObj != null) message = messageObj.toString();
    if (typeObj != null) type = typeObj.toString();

    // Powd bdu to kod statusu lub typ wyjtku
    String reason = (code != null ? code : type);

    out.println("<HTML>");
    out.println("<HEAD><TITLE>" + reason + ": " + message +
                "</TITLE></HEAD>");
    out.println("<BODY>");
    out.println("<H1>" + reason + "</H1>");
    out.println("<H2>" + message + "</H2>");    
    out.println("<HR>");
    out.println("<I>Bd przy dostpie do " + req.getRequestURI() + "</I>");
    out.println("</BODY></HTML>");
  }
}
