import java.io.*;
import java.util.*;
import javax.servlet.*;
import javax.servlet.http.*;

public class ToolServlet extends HttpServlet {

  Tool[] tools = null;

  public void init() throws ServletException {    
    // Pobranie danych narzdzi w init w celu zachowania prostoty
    String toolsFile = 
      getServletContext().getInitParameter("toolsFile"); // z web.xml
    if (toolsFile == null) {
      throw new ServletException("Plik danych narzdzi musi by okrelony jako " +
                                 "parametr inicjalizacji kontekstu toolsFile");
    }
    log("Pobieranie narzdzi z " + toolsFile);
    try {
      tools = Tool.loadTools(toolsFile);
      if (tools.length == 0) {
        log("Nie odnaleziono narzdzi w " + toolsFile);
      }
      else {
        log(tools.length + " narzdzi znaleziono w " + toolsFile);
      }
    }
    catch (Exception e) {
      throw new ServletException(e);
    }
  }

  public void doGet(HttpServletRequest req, HttpServletResponse res)
                               throws ServletException, IOException {
    Tool[] tools = null;
    
    // Umieszczenie waciwego atrybutu tools w daniu
    String state = req.getParameter("state");
    if (state == null) {
      req.setAttribute("tools", getTools());
    }
    else {
      req.setAttribute("tools", getTools(state));
    }
    
    // Przesanie dania do JSP w celu dalszego przetworzenia
    RequestDispatcher disp = req.getRequestDispatcher("/toolview-tag.jsp");
    disp.forward(req, res);
  }

  public Tool[] getTools() {
    return tools;
  }

  public Tool[] getTools(String state) {
    List list = new LinkedList();
    for (int i = 0; i < tools.length; i++) {
      if (tools[i].getStateFlag().equalsIgnoreCase(state)) {
        list.add(tools[i]);
      }
    }
    return (Tool[]) list.toArray(new Tool[0]);
  }
}
