import java.applet.*;
import java.awt.*;
import java.io.*;
import java.util.*;
import java.net.URL;                     // nowy dodatek
import com.oreilly.servlet.HttpMessage;  // klasa wspierajca, przedstawiona dalej
import java.net.Socket;               // Nowy dodatek
import java.rmi.*;           // Nowy dodatek
import java.rmi.registry.*;  // Nowy dodatek
	


public class DaytimeApplet extends Applet {
  TextField httpText, httpObject, socketText, socketObject, RMIObject;
  Button refresh;
  static final int DEFAULT_PORT=1313;  // Nowy dodatek

private int getSocketPort() {
  try { return Integer.parseInt(getParameter("socketPort")); }
  catch (NumberFormatException e) { return DEFAULT_PORT; }
}

  public void init() {
    // Konstruowanie interfejsu uytkownika

    setLayout(new BorderLayout());

    // Po lewej stronie dodanie etykiet dla rnych mechanizmw komunikacji
    Panel west = new Panel();
    west.setLayout(new GridLayout(5, 1));
    west.add(new Label("Tekst HTTP: ", Label.RIGHT));
    west.add(new Label("Obiekt HTTP: ", Label.RIGHT));
    west.add(new Label("Tekst gniazda: ", Label.RIGHT));
    west.add(new Label("Obiekt gniazda: ", Label.RIGHT));
    west.add(new Label("Obiekt RMI: ", Label.RIGHT));
    add("West", west);

    // Po prawej utworzenie pl tekstowych wywietlajcych otrzymane wartoci czasu
    Panel center = new Panel();
    center.setLayout(new GridLayout(5, 1));

    httpText = new TextField();
    httpText.setEditable(false);
    center.add(httpText);

    httpObject = new TextField();
    httpObject.setEditable(false);
    center.add(httpObject);

    socketText = new TextField();
    socketText.setEditable(false);
    center.add(socketText);

    socketObject = new TextField();
    socketObject.setEditable(false);
    center.add(socketObject);

    RMIObject = new TextField();
    RMIObject.setEditable(false);
    center.add(RMIObject);

    add("Center", center);

    // Na dole utworzenie przycisku uaktualniajcego czas
    Panel south = new Panel();
    refresh = new Button("Odswie");
    south.add(refresh);
    add("South", south);
  }

  public void start() {
    refresh();
  }

  private void refresh() {
    // pobranie i wywietlenie wartoci czasu
    httpText.setText(getDateUsingHttpText());
    httpObject.setText(getDateUsingHttpObject());
    socketText.setText(getDateUsingSocketText());
    socketObject.setText(getDateUsingSocketObject());
    RMIObject.setText(getDateUsingRMIObject());
  }

 private String getDateUsingHttpText() {
    try {
      // Tworzenie URL-a u odnoszcego si do serwletu
      URL url = new URL(getCodeBase(), "/servlet/DaytimeServlet");

      // Tworzenie com.oreilly.servlet.HttpMessage w celu 
      // porozumienia si z tym URL-em
      HttpMessage msg = new HttpMessage(url);

      // Wysanie wiadomoci GET serwletowi, bez acucha zapytania
      // Pobranie odpowiedzi jako InputStream
      InputStream in = msg.sendGetMessage();

      // Opakowanie InputStream klas DataInputStream
      DataInputStream result =
        new DataInputStream(new BufferedInputStream(in));

      // Odczytanie pierwszej linii odpowiedzi, ktra powinna by
      // acuchem reprezentujcym  aktualny czasu
      String date = result.readLine();

      // Zamknicie InputStream
      in.close();

      // Zwrcenie odczytanego czasu
      return date;
    }
    catch (Exception e) {
      // Jeeli nastpi problem, wypisz do System.out
      // (zazwyczaj konsola Javy) i zwrci null
      e.printStackTrace();
      return null;
    }
  }

  private String getDateUsingHttpObject() {
  try {
    // Tworzenie URL-a u odnoszcego si do serwletu
    URL url = new URL(getCodeBase(), "/servlet/DaytimeServlet");

    // Tworzenie com.oreilly.servlet.HttpMessage w celu porozumienia si z tym URL-em
    HttpMessage msg = new HttpMessage(url);

    // Tworzenie zbioru waciwoci w celu podania format=obiekt
    Properties props = new Properties();
    props.put("format", "object");

    // Wysanie wiadomoci GET serwletowi, przekazanie props jako acucha zapytania
    // Pobranie odpowiedzi jako ObjectInputStream
    InputStream in = msg.sendGetMessage(props);
    ObjectInputStream result = new ObjectInputStream(in);

    // Odczytanie obiektu Date ze strumienia
    Object obj = result.readObject();
    Date date = (Date)obj;

    // Zwrcenie acuchowej reprezentacji Date
    return date.toString();
  }
  catch (Exception e) {
    // Jeeli nastpi problem, wypisze do System.out
    // (zazwyczaj konsola Javy) i zwrci null
    e.printStackTrace();
    return null;
  }
}


  private String getDateUsingSocketText() {
  InputStream in = null;
  try {
    // Ustanowienie poczenia przez gniazdo z serwletem
    Socket socket = new Socket(getCodeBase().getHost(), getSocketPort());

    // Wypisanie pustej linii, oznaczajcej ch pobrania 
    // czasu jako zwykego tekstu
    PrintStream out = new PrintStream(socket.getOutputStream());
    out.println();
    out.flush();

    // Odczytanie pierwszej linii odpowiedzi
    // Powinna ona zawiera aktualny czas
    in = socket.getInputStream();
    DataInputStream result =
      new DataInputStream(new BufferedInputStream(in));
    String date = result.readLine();

    // Zwrcenie otrzymanego acucha
    return date;
  }
  catch (Exception e) {
    // Jeeli wystpi problem, wypisanie do System.out
    // (zazwyczaj konsola Javy) i zwrcenie null
    e.printStackTrace();
    return null;
  }
  finally {
    // Zawsze zamknicie poczenia
    // Poniszy kod jest wykonywany niezalenie od 
    // przebiegu bloku
    if (in != null) {
      try { in.close(); }
      catch (IOException ignored) { }
    }
  }
}
  

  private String getDateUsingSocketObject() {
    InputStream in = null;
  try {
    // Ustanowienie poczenia z serwletem
    Socket socket = new Socket(getCodeBase().getHost(), getSocketPort());

    // Wypisanie linii "object", wskazujcej ch pobrania 
    // czasu jako zserializowanego obiektu klasy Date
    PrintStream out = new PrintStream(socket.getOutputStream());
    out.println("object");
    out.flush();

    // Stworzenie ObjectInputStream odczytujcego odpowied
    in = socket.getInputStream();
    ObjectInputStream result =
      new ObjectInputStream(new BufferedInputStream(in));

    // Odczytanie obiektu i zapamitania go jako Data
    Object obj = result.readObject();
    Date date = (Date)obj;

    // Zwrcenie acuchowej reprezentacji otrzymanego
    // obiektu klasy Date
    return date.toString();
  }
  catch (Exception e) {
    // Jeeli wystpi problem, wypisanie do System.out
    // (zazwyczaj konsola Javy) i zwrcenie null
    e.printStackTrace();
    return null;
  }
  finally {
    // Zawsze zamknicie poczenia    
    // Poniszy kod jest wykonywany niezalenie od 
    // przebiegu bloku try
    if (in != null) {
      try { in.close(); }
      catch (IOException ignored) { }
    }
  }

  }


private String getRegistryHost() {
  return getCodeBase().getHost();
}
 
private int getRegistryPort() {
  try { return Integer.parseInt(getParameter("registryPort")); }
  catch (NumberFormatException e) { return Registry.REGISTRY_PORT; }
}
 
private String getRegistryName() {
  String nazwa = getParameter("registryName");
  if (nazwa == null) {
    nazwa = "DaytimeServlet";  // domylnie
  }
  return nazwa;
}
  
private String getDateUsingRMIObject() {
  try {
    Registry registry =
      LocateRegistry.getRegistry(getRegistryHost(), getRegistryPort());
    DaytimeServer daytime =
      (DaytimeServer)registry.lookup(getRegistryName());
    return daytime.getDate().toString();
  }
  catch (ClassCastException e) {
    System.out.println("Otrzymany obiekt to nie obiekt klasy DaytimeServer: " +
                       e.getMessage());
  }
  catch (NotBoundException e) {
    System.out.println(getRegistryName() + " nie dowizany: " + e.getMessage());
  }
  catch (RemoteException e) {
    System.out.println("Wyjtek zdalny: " + e.getMessage());
  }
  catch (Exception e) {
    System.out.println("Problem z pobraniem referencji do DaytimeServer: " +
                       e.getClass().getName() + ": " + e.getMessage());
  }
  return null;
}

  public boolean handleEvent(Event event) {
    // Po przyciniciu przycisku "Odwie" odwieenie ekranu
    // Wykorzystanie zdarze JDK 1.0 w celu zapewnienia maksymalnej przenonoci
    switch (event.id) {
      case Event.ACTION_EVENT:
        if (event.target == refresh) {
          refresh();
          return true;
        }
    }
    return false;
  }
  

 
}
