import java.sql.*;
import java.io.*;
import javax.servlet.*;
import javax.servlet.http.*;

class ConnectionHolder implements HttpSessionBindingListener {
  private Connection con = null;
  
  public ConnectionHolder(Connection con) {
    // Zapisz Connection
    this.con = con;
    try {
      con.setAutoCommit(false);	// wcz obsug transakcji
    }
    catch(SQLException e) {
      // obsu zgoszone wyjtki
    }
  }

  public Connection getConnection() {
    return con;
  }

  public void valueBound(HttpSessionBindingEvent event) {
    // nic nie rb kiedy jest dodawany do sesji
  }
  
  public void valueUnbound(HttpSessionBindingEvent event) {
    // cofnij zmiany przy usuwaniu z sesji
    // lub kiedy sesja wygasa  
    try {
      if (con != null) {
        con.rollback(); // porzu wszystkie niezatwierdzone dane
        con.close();
      }
    }
    catch (SQLException e) {
      // poinformuj      
    }
  }
}

/* Waciwy serwlet */
public class ConnectionPerClient extends HttpServlet {
  public void init() throws ServletException {
      try {
    Class.forName("oracle.jdbc.driver.OracleDriver");
       }
    
catch (ClassNotFoundException e ) {
  throw new UnavailableException ("Nie mona zaadowa sterownika bazy danych Oracle");
  }
}

    public void doGet (HttpServletRequest req, HttpServletResponse res)
                        throws ServletException, IOException {
      res.setContentType("text/plain; charset=ISO-8859-2");
      PrintWriter out = res.getWriter();

      HttpSession session = req.getSession(true);
      Connection con;

      // zsynchronizuj: Bez tego dwa uchwyty mog by utworzone dla jednego klienta.
      synchronized (session) {
      // sprbuj otrzyma dla tego klienta uchwyt poczenia 
      ConnectionHolder holder = 
            (ConnectionHolder) session.getAttribute("servletapp.connection");

   // stwrz (i przechowuj) nowe poczenie i uchwyt jeli to konieczne
      if ( holder == null) {
         try {
            holder = new ConnectionHolder(DriverManager.getConnection(
               "jdbc:oracle:oci7:ordersdb", "user", "passwd"));
            session.setAttribute("servletapp.connection", holder);
         }
         catch (SQLException e) {
         log(" Nie mona otrzyma poczenia db", e);
         }
      }

  // Pobierz faktyczne poczenie od uchwytu
  con = holder.getConnection();
 }

// uyj teraz poczenia
try {
   Statement stmt = con.createStatement();
   stmt.executeUpdate(
      "UPDATE MAGAZYN SET ILOSC = (ILOSC - 10) WHERE PRODUKT_ID = 7");   
   stmt.executeUpdate(
      "UPDATE WYSYLKA SET WYSLANE = (WYSLANE + 10) WHERE PRODUCT_ID = 7");

   // Obsu kart kredytow i potwierd transakcj w kolejnym serwlecie
   res.sendRedirect(res.encodeRedirectURL(
      req.getContextPath() + "/servlet/CreditCardHandler"));
      }
      catch(Exception e) {
         // Jakikolwiek bd powoduje cofnicie transakcji

      try {
            con.rollback();
            session.removeAttribute("servletapp.connection");
         }

         catch (Exception ignored){}
            out.println("Zamwienie sie nie powiodo. "
                    + "Skontaktuj si z serwisem technicznym.");
      }
   }
}
