import java.awt.*;
import java.io.*;
import javax.servlet.*;
import javax.servlet.http.*;

import Acme.JPM.Encoders.GifEncoder; 

import javachart.chart.*;

public class SimpleChart extends HttpServlet {

static final int WIDTH = 450;
static final int HEIGHT = 320;

public void doGet(HttpServletRequest req, HttpServletResponse res)
                          throws ServletException ,IOException {
   ServletOutputStream out = res.getOutputStream();

   Frame frame = null;
   Graphics g = null;

try {
   // Utwrz prosty wykres
   BarChart chart = new BarChart("Jabka i pomaracze");

   // Nadaj mu tytu
   chart.getBackground().setTitleFont(new Font("Serif",   
        Font.PLAIN, 24));
   chart.getBackground().setTitleString("Porwnanie jabek i pomaraczy");

   // Poka, umie i dostosuj jego legend
   chart.setLegendVisible(true) ;
   chart.getLegend().setLlX(0.4);
   chart.getLegend().setLlY(0.75);
   chart.getLegend().setIconHeight(0.04);
   chart.getLegend().setIconWidth(0.04);
   chart.getLegend().setIconGap(0.02);
   chart.getLegend().setVerticalLayout(false) ;

   // Nadaj mu jego dane i etykiety
   double[] appleData = {950, 1005, 1210, 1165, 1255};

   chart.addDataSet("Jabka", appleData) ;

   double[] orangeData = {1435, 1650, 1555, 1440, 1595};
   chart.addDataSet("Pomaracze", orangeData) ;

   String[] labels = {"1997", "1998", "1999", "2000", "2001"};
   chart.getXAxis().addLabels(labels) ;

   // Pokoloruj jabka na czerwono, a pomaracze na pomaraczowo
   chart.getDatasets()[0].getGc().setFillColor(Color.red) ;
   chart.getDatasets()[1].getGc().setFillColor(Color.orange);

   // Nazwij osie
   chart.getXAxis().setTitleString("Rok");
   chart.getYAxis().setTitleString("Tony skonsumowane");
   
   // Nadaj odpowiedni rozmiar
   chart.resize(WIDTH, HEIGHT);

   // Utwrz niepokazywan ramk
   frame = new Frame () ;
   frame.addNotify() ;

   // Pobierz obszar grafiki o odpowiednim rozmiarze, uywajc Ramki
   Image image = frame.createImage(WIDTH, HEIGHT);
   g = image.getGraphics();

   // Popro wykres aby wrysowa si w poza-ekranowym kontekscie grafiki
   chart.drawGraph(g) ;

   // Zakoduj i odelij to, co zostao namalowane
   res.setContentType ("image/gif") ;
   GifEncoder encoder = new GifEncoder(image, out);
   encoder.encode() ;
}
   finally {
   // Zwolnij zasoby
   if (g != null) g.dispose();
   if (frame != null) frame.removeNotify();
   } 
  }
 }
